/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import io.crate.role.Roles;

public class TrustAuthenticationMethod
implements AuthenticationMethod {
    static final String NAME = "trust";
    private final Roles roles;

    public TrustAuthenticationMethod(Roles roles) {
        this.roles = roles;
    }

    @Override
    public Role authenticate(Credentials credentials, ConnectionProperties connectionProperties) {
        String username = credentials.username();
        assert (username != null) : "User name must be not null on trust authentication method";
        Role user = this.roles.findUser(username);
        if (user == null) {
            throw new RuntimeException("trust authentication failed for user \"" + username + "\"");
        }
        return user;
    }

    @Override
    public String name() {
        return NAME;
    }
}

