/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.v2;

import io.crate.blob.BlobContainer;
import io.crate.blob.v2.BlobIndicesService;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardPath;
import org.jetbrains.annotations.Nullable;

public class BlobShard {
    private static final String BLOBS_SUB_PATH = "blobs";
    private final BlobContainer blobContainer;
    private final IndexShard indexShard;
    private final Logger logger;
    private final Path blobDir;
    private long totalSize = 0L;
    private long blobsCount = 0L;

    public BlobShard(IndexShard indexShard, @Nullable Path globalBlobPath) {
        this.indexShard = indexShard;
        this.logger = Loggers.getLogger(BlobShard.class, indexShard.shardId(), new String[0]);
        this.blobDir = this.resolveBlobDir(indexShard.indexSettings(), indexShard.shardPath(), globalBlobPath);
        this.logger.info("creating BlobContainer at {}", (Object)this.blobDir);
        this.blobContainer = new BlobContainer(this.blobDir);
    }

    void initialize() {
        try {
            this.blobContainer.visitBlobs((FileVisitor<Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    ++BlobShard.this.blobsCount;
                    long fileSize = attrs.size();
                    BlobShard.this.totalSize += fileSize;
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.logger.error("Unable to compute initial blob shard size and count", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Path getBlobDir() {
        return this.blobDir;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public byte[][] currentDigests(byte prefix) {
        return this.blobContainer.cleanAndReturnDigests(prefix);
    }

    public boolean delete(String digest) {
        try {
            boolean deleted;
            Path blobPath = this.blobContainer.getFile(digest).toPath();
            long blobSize = 0L;
            if (Files.exists(blobPath, new LinkOption[0])) {
                blobSize = Files.size(blobPath);
            }
            if (deleted = Files.deleteIfExists(blobPath)) {
                this.decrementStats(blobSize);
            }
            return deleted;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void incrementStats(long size) {
        this.totalSize += size;
        ++this.blobsCount;
    }

    private void decrementStats(long size) {
        this.totalSize -= size;
        --this.blobsCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getBlobsCount() {
        return this.blobsCount;
    }

    public BlobContainer blobContainer() {
        return this.blobContainer;
    }

    public ShardRouting shardRouting() {
        return this.indexShard.routingEntry();
    }

    void deleteShard() {
        Path baseDirectory = this.blobContainer.getBaseDirectory();
        try {
            IOUtils.rm((Path[])new Path[]{baseDirectory});
        }
        catch (IOException e) {
            this.logger.warn("Could not delete blob directory: {} {}", (Object)baseDirectory, (Object)e);
        }
    }

    private Path resolveBlobDir(IndexSettings indexSettings, ShardPath shardPath, @Nullable Path globalBlobPath) {
        Path blobPath;
        String tableBlobPath = BlobIndicesService.SETTING_INDEX_BLOBS_PATH.get(indexSettings.getSettings());
        if (Strings.isNullOrEmpty(tableBlobPath)) {
            if (globalBlobPath == null) {
                return shardPath.getDataPath().resolve(BLOBS_SUB_PATH);
            }
            assert (BlobIndicesService.ensureExistsAndWritable(globalBlobPath)) : "global blob path must exist and be writable";
            blobPath = globalBlobPath;
        } else {
            blobPath = PathUtils.get(tableBlobPath, new String[0]);
        }
        Path rootDataPath = shardPath.getRootDataPath();
        Path clusterDataDir = rootDataPath.getParent().getParent();
        Path pathToShard = clusterDataDir.relativize(shardPath.getShardStatePath());
        return blobPath.resolve(pathToShard).resolve(BLOBS_SUB_PATH);
    }
}

