/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.CrateExceptionVisitor;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ColumnUnknownException
extends RuntimeException
implements ResourceUnknownException,
TableScopeException {
    private final RelationName relationName;
    private final RelationType relationType;

    public ColumnUnknownException(ColumnIdent columnIdent, RelationName relationName) {
        this(String.format(Locale.ENGLISH, "Column %s unknown", columnIdent.sqlFqn()), relationName, RelationType.TABLE);
    }

    private ColumnUnknownException(String message, RelationName relationName, RelationType relationType) {
        super(message);
        this.relationName = relationName;
        this.relationType = relationType;
    }

    public static ColumnUnknownException ofUnknownRelation(String message) {
        return new ColumnUnknownException(message, null, RelationType.UNKNOWN);
    }

    public static ColumnUnknownException ofTableFunctionRelation(String message, RelationName relationName) {
        return new ColumnUnknownException(message, relationName, RelationType.TABLE_FUNCTION);
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return this.relationName == null ? Collections.emptyList() : Collections.singletonList(this.relationName);
    }

    @Override
    public <C, R> R accept(CrateExceptionVisitor<C, R> exceptionVisitor, C context) {
        return exceptionVisitor.visitColumnUnknownException(this, context);
    }

    @NotNull
    public RelationType relationType() {
        return this.relationType;
    }

    public static enum RelationType {
        TABLE,
        TABLE_FUNCTION,
        UNKNOWN;

    }
}

