/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.UnauthorizedException;
import io.crate.rest.action.HttpErrorStatus;
import io.crate.role.Permission;
import java.util.Locale;

public class MissingPrivilegeException
extends UnauthorizedException {
    private static final String MESSAGE_TMPL = "Missing '%s' privilege for user '%s'";

    public MissingPrivilegeException(String userName, Permission permission) {
        super(String.format(Locale.ENGLISH, MESSAGE_TMPL, new Object[]{permission, userName}));
    }

    public MissingPrivilegeException(String userName) {
        super(String.format(Locale.ENGLISH, "Missing privilege for user '%s'", userName));
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.MISSING_USER_PRIVILEGES;
    }
}

