/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ConflictException;
import io.crate.exceptions.SchemaScopeException;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UserDefinedFunctionAlreadyExistsException
extends ElasticsearchException
implements ConflictException,
SchemaScopeException {
    private final String schema;

    public UserDefinedFunctionAlreadyExistsException(UserDefinedFunctionMetadata udfMetadata) {
        super(String.format(Locale.ENGLISH, "User defined Function '%s.%s' already exists.", udfMetadata.schema(), udfMetadata.specificName()), new Object[0]);
        this.schema = udfMetadata.schema();
    }

    public UserDefinedFunctionAlreadyExistsException(StreamInput in) throws IOException {
        super(in);
        this.schema = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.schema);
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.USER_DEFINED_FUNCTION_WITH_SAME_SIGNATURE_EXISTS_ALREADY;
    }
}

