/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.SchemaScopeException;
import io.crate.rest.action.HttpErrorStatus;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UserDefinedFunctionUnknownException
extends ElasticsearchException
implements ResourceUnknownException,
SchemaScopeException {
    private final String schema;

    public UserDefinedFunctionUnknownException(String schema, String name, List<DataType<?>> types) {
        super(String.format(Locale.ENGLISH, "Cannot resolve user defined function: '%s.%s(%s)'", schema, name, types.stream().map(DataType::getName).collect(Collectors.joining(","))), new Object[0]);
        this.schema = schema;
    }

    public UserDefinedFunctionUnknownException(StreamInput in) throws IOException {
        super(in);
        this.schema = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.schema);
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.USER_DEFINED_FUNCTION_UNKNOWN;
    }
}

