/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution;

import io.crate.Streamer;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.Bucket;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.PageResultListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.jetbrains.annotations.NotNull;

public class IncrementalPageBucketReceiver<T>
implements PageBucketReceiver {
    private final Function<T, Iterable<Row>> finisher;
    private final BiConsumer<T, Row> accumulator;
    private final T state;
    private final AtomicInteger remainingUpstreams;
    private final CompletableFuture<Iterable<Row>> processingFuture = new CompletableFuture();
    private final Executor executor;
    private final Streamer<?>[] streamers;
    private final BatchIterator<Row> lazyBatchIterator;
    private CompletableFuture<?> currentlyAccumulating;

    public IncrementalPageBucketReceiver(Collector<Row, T, Iterable<Row>> collector, RowConsumer rowConsumer, Executor executor, Streamer<?>[] streamers, int upstreamsCount) {
        this.state = collector.supplier().get();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
        this.executor = executor;
        this.streamers = streamers;
        this.remainingUpstreams = new AtomicInteger(upstreamsCount);
        this.lazyBatchIterator = CollectingBatchIterator.newInstance(() -> {}, t -> {}, () -> this.processingFuture, (boolean)true);
        rowConsumer.accept(this.lazyBatchIterator, null);
    }

    private void processRows(Bucket rows) {
        for (Row row : rows) {
            this.accumulator.accept(this.state, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBucket(int bucketIdx, Bucket rows, boolean isLast, PageResultListener pageResultListener) {
        if (this.processingFuture.isCompletedExceptionally()) {
            pageResultListener.needMore(false);
            return;
        }
        pageResultListener.needMore(!isLast);
        T t2 = this.state;
        synchronized (t2) {
            if (this.currentlyAccumulating == null) {
                try {
                    this.currentlyAccumulating = CompletableFuture.runAsync(() -> this.processRows(rows), this.executor);
                }
                catch (EsRejectedExecutionException e) {
                    this.processingFuture.completeExceptionally(e);
                }
            } else {
                this.currentlyAccumulating = this.currentlyAccumulating.whenComplete((r, t) -> {
                    if (t == null) {
                        try {
                            this.processRows(rows);
                        }
                        catch (Exception e) {
                            RuntimeException runtimeErr = Exceptions.toRuntimeException((Throwable)t);
                            this.processingFuture.completeExceptionally(runtimeErr);
                            throw runtimeErr;
                        }
                    } else {
                        RuntimeException runtimeErr = Exceptions.toRuntimeException((Throwable)t);
                        this.processingFuture.completeExceptionally(runtimeErr);
                        throw runtimeErr;
                    }
                });
            }
        }
        if (isLast && this.remainingUpstreams.decrementAndGet() == 0) {
            this.currentlyAccumulating.whenComplete((r, t) -> this.consumeRows());
        }
    }

    @Override
    public Streamer<?>[] streamers() {
        return this.streamers;
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.processingFuture;
    }

    @Override
    public void consumeRows() {
        try {
            this.processingFuture.complete(this.finisher.apply(this.state));
        }
        catch (Exception e) {
            this.processingFuture.completeExceptionally(e);
        }
    }

    public void kill(@NotNull Throwable t) {
        this.lazyBatchIterator.kill(t);
        this.processingFuture.completeExceptionally(t);
    }
}

