/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;

public class AddColumnRequest
extends AcknowledgedRequest<AddColumnRequest> {
    private final RelationName relationName;
    private final List<Reference> colsToAdd;
    private final IntArrayList pKeyIndices;
    private final Map<String, String> checkConstraints;

    public AddColumnRequest(@NotNull RelationName relationName, @NotNull List<Reference> colsToAdd, @NotNull Map<String, String> checkConstraints, @NotNull IntArrayList pKeyIndices) {
        this.relationName = relationName;
        this.colsToAdd = colsToAdd;
        this.checkConstraints = checkConstraints;
        this.pKeyIndices = pKeyIndices;
        assert (!colsToAdd.isEmpty()) : "Columns to add must not be empty";
    }

    public AddColumnRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.checkConstraints = in.readMap(LinkedHashMap::new, StreamInput::readString, StreamInput::readString);
        this.colsToAdd = in.readList(Reference::fromStream);
        int numPKIndices = in.readVInt();
        this.pKeyIndices = new IntArrayList(numPKIndices);
        for (int i = 0; i < numPKIndices; ++i) {
            this.pKeyIndices.add(in.readVInt());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeMap(this.checkConstraints, StreamOutput::writeString, StreamOutput::writeString);
        out.writeCollection(this.colsToAdd, Reference::toStream);
        out.writeVInt(this.pKeyIndices.size());
        for (int i = 0; i < this.pKeyIndices.size(); ++i) {
            out.writeVInt(this.pKeyIndices.get(i));
        }
    }

    @NotNull
    public RelationName relationName() {
        return this.relationName;
    }

    @NotNull
    public Map<String, String> checkConstraints() {
        return this.checkConstraints;
    }

    @NotNull
    public List<Reference> references() {
        return this.colsToAdd;
    }

    @NotNull
    public IntArrayList pKeyIndices() {
        return this.pKeyIndices;
    }
}

