/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateBlobTableRequest
extends MasterNodeRequest<CreateBlobTableRequest>
implements AckedRequest {
    private final RelationName name;
    private final Settings settings;

    public CreateBlobTableRequest(RelationName name, Settings settings) {
        this.name = name;
        this.settings = settings;
    }

    public CreateBlobTableRequest(StreamInput in) throws IOException {
        this.name = new RelationName(in);
        this.settings = Settings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.name.writeTo(out);
        Settings.writeSettingsToStream(out, this.settings);
    }

    public RelationName name() {
        return this.name;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }
}

