/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DropTableClusterStateTaskExecutor;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDropTableAction
extends AbstractDDLTransportAction<DropTableRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions(false, true, true, true);
    private final DropTableClusterStateTaskExecutor executor;

    @Inject
    public TransportDropTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-table");
        this.executor = new DropTableClusterStateTaskExecutor(deleteIndexService, ddlClusterStateService);
    }

    @Override
    public ClusterStateTaskExecutor<DropTableRequest> clusterStateTaskExecutor(DropTableRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(DropTableRequest request, ClusterState state) {
        RelationName relation = request.tableIdent();
        String templateName = PartitionName.templateName(relation.schema(), relation.name());
        Metadata metadata = state.metadata();
        boolean isPartitioned = metadata.templates().containsKey(templateName);
        IndicesOptions indicesOptions = isPartitioned ? IndicesOptions.LENIENT_EXPAND_OPEN : INDICES_OPTIONS;
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, IndexNameExpressionResolver.concreteIndexNames(metadata, indicesOptions, relation.indexNameOrAlias()));
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        public static final String NAME = "internal:crate:sql/table/drop";

        private Action() {
            super(NAME);
        }
    }
}

