/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

public class DoubleIndexer
implements ValueIndexer<Number> {
    private final Reference ref;
    private final String name;

    public DoubleIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull Number value, IndexDocumentBuilder docBuilder) throws IOException {
        double doubleValue = value.doubleValue();
        if (this.ref.hasDocValues() && this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new DoubleField(this.name, doubleValue, Field.Store.NO));
        } else {
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new DoublePoint(this.name, new double[]{doubleValue}));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedNumericDocValuesField(this.name, NumericUtils.doubleToSortableLong((double)doubleValue)));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, doubleValue));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
        }
        docBuilder.translogWriter().writeValue(value);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

