/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.jetbrains.annotations.NotNull;

public class IntIndexer
implements ValueIndexer<Number> {
    private final String name;
    private final Reference ref;

    public IntIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull Number value, IndexDocumentBuilder docBuilder) throws IOException {
        int intValue = value.intValue();
        if (this.ref.hasDocValues() && this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new IntField(this.name, intValue, Field.Store.NO));
        } else {
            if (this.ref.indexType() != IndexType.NONE) {
                docBuilder.addField((IndexableField)new IntPoint(this.name, new int[]{intValue}));
            }
            if (this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new SortedNumericDocValuesField(this.name, (long)intValue));
            } else {
                if (docBuilder.maybeAddStoredField()) {
                    docBuilder.addField((IndexableField)new StoredField(this.name, intValue));
                }
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
        }
        docBuilder.translogWriter().writeValue(intValue);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

