/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;

public class StringIndexer
implements ValueIndexer<String> {
    public static final FieldType FIELD_TYPE = new FieldType();
    private final Reference ref;

    public StringIndexer(Reference ref) {
        this.ref = ref;
    }

    @Override
    public void indexValue(@NotNull String value, IndexDocumentBuilder docBuilder) throws IOException {
        String name = this.ref.storageIdent();
        BytesRef binaryValue = new BytesRef((CharSequence)value);
        if (this.ref.indexType() != IndexType.NONE) {
            Field field = new Field(name, binaryValue, (IndexableFieldType)FIELD_TYPE);
            docBuilder.addField((IndexableField)field);
            if (!this.ref.hasDocValues()) {
                docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
            }
        }
        if (this.ref.hasDocValues()) {
            docBuilder.addField((IndexableField)new SortedSetDocValuesField(name, binaryValue));
        } else if (docBuilder.maybeAddStoredField()) {
            docBuilder.addField((IndexableField)new StoredField(name, value));
        }
        docBuilder.translogWriter().writeValue(value);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }
}

