/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RelationName;
import io.crate.planner.distribution.DistributionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForeignCollectPhase
extends AbstractProjectionsPhase
implements CollectPhase {
    private final String handlerNode;
    private final RelationName relationName;
    private final List<Symbol> toCollect;
    private final Symbol query;
    @Nullable
    private final String executeAs;
    private DistributionInfo distributionInfo = DistributionInfo.DEFAULT_BROADCAST;

    public ForeignCollectPhase(UUID jobId, int phaseId, String handlerNode, RelationName relationName, List<Symbol> toCollect, Symbol query, @NotNull String executeAs) {
        super(jobId, phaseId, relationName.fqn(), null);
        this.handlerNode = handlerNode;
        this.relationName = relationName;
        this.toCollect = toCollect;
        this.outputTypes = Symbols.typeView(toCollect);
        this.query = query;
        this.executeAs = executeAs;
    }

    public ForeignCollectPhase(StreamInput in) throws IOException {
        super(in);
        this.handlerNode = in.readString();
        this.relationName = new RelationName(in);
        this.toCollect = Symbols.fromStream(in);
        this.outputTypes = ForeignCollectPhase.extractOutputTypes(this.toCollect, this.projections);
        this.distributionInfo = new DistributionInfo(in);
        this.query = Symbol.fromStream(in);
        this.executeAs = in.getVersion().onOrAfter(Version.V_5_8_0) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.handlerNode);
        this.relationName.writeTo(out);
        Symbols.toStream(this.toCollect, out);
        this.distributionInfo.writeTo(out);
        Symbol.toStream(this.query, out);
        if (out.getVersion().onOrAfter(Version.V_5_8_0)) {
            out.writeOptionalString(this.executeAs);
        }
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.FOREIGN_COLLECT;
    }

    @Override
    public Collection<String> nodeIds() {
        return List.of(this.handlerNode);
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitForeignCollect(this, context);
    }

    @Override
    public List<Symbol> toCollect() {
        return this.toCollect;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public Symbol query() {
        return this.query;
    }

    @Nullable
    public String executeAs() {
        return this.executeAs;
    }
}

