/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FilterProjection
extends Projection {
    private final Symbol query;
    private final List<Symbol> outputs;
    private RowGranularity requiredGranularity = RowGranularity.CLUSTER;

    public FilterProjection(Symbol query, List<Symbol> outputs) {
        assert (!query.any(Symbol.IS_COLUMN.or(s -> s instanceof SelectSymbol))) : "FilterProjection cannot operate on Reference, Field or SelectSymbol symbols: " + String.valueOf(query);
        assert (outputs.stream().noneMatch(s -> s.any(Symbol.IS_COLUMN.or(x -> x instanceof SelectSymbol)))) : "Cannot operate on Reference, Field or SelectSymbol symbols: " + String.valueOf(outputs);
        this.query = query;
        this.outputs = outputs;
    }

    public FilterProjection(StreamInput in) throws IOException {
        this.query = Symbol.fromStream(in);
        this.outputs = Symbols.fromStream(in);
        this.requiredGranularity = RowGranularity.fromStream(in);
    }

    @Override
    public RowGranularity requiredGranularity() {
        return this.requiredGranularity;
    }

    public void requiredGranularity(RowGranularity requiredRowGranularity) {
        this.requiredGranularity = requiredRowGranularity;
    }

    public Symbol query() {
        return this.query;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.FILTER;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitFilterProjection(this, context);
    }

    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterProjection that = (FilterProjection)o;
        return Objects.equals(this.query, that.query);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbol.toStream(this.query, out);
        Symbols.toStream(this.outputs, out);
        RowGranularity.toStream(this.requiredGranularity, out);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + (this.query != null ? this.query.hashCode() : 0);
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put((Object)"type", (Object)"Filter").put((Object)"filter", (Object)this.query.toString()).map();
    }
}

