/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.Streamer;
import io.crate.data.Bucket;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.engine.InitializationTracker;
import io.crate.execution.engine.PagingUnsupportedResultListener;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.transport.JobResponse;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.jetbrains.annotations.NotNull;

final class BucketForwarder {
    private final List<PageBucketReceiver> pageBucketReceivers;
    private final int bucketIdx;
    private final InitializationTracker initializationTracker;

    static BiConsumer<List<? extends Bucket>, Throwable> asConsumer(List<PageBucketReceiver> pageBucketReceivers, int bucketIdx, InitializationTracker initializationTracker) {
        BucketForwarder forwarder = new BucketForwarder(pageBucketReceivers, bucketIdx, initializationTracker);
        return (buckets, failure) -> {
            if (failure == null) {
                forwarder.setBuckets((List<? extends Bucket>)buckets);
            } else {
                forwarder.failed(SQLExceptions.unwrap(failure));
            }
        };
    }

    static ActionListener<JobResponse> asActionListener(List<PageBucketReceiver> pageBucketReceivers, int bucketIdx, InitializationTracker initializationTracker) {
        BucketForwarder forwarder = new BucketForwarder(pageBucketReceivers, bucketIdx, initializationTracker);
        return new BucketForwardingActionListener(pageBucketReceivers.get(0).streamers(), forwarder);
    }

    private BucketForwarder(List<PageBucketReceiver> pageBucketReceivers, int bucketIdx, InitializationTracker initializationTracker) {
        assert (!pageBucketReceivers.isEmpty()) : "pageBucketReceivers must not be empty";
        this.pageBucketReceivers = pageBucketReceivers;
        this.bucketIdx = bucketIdx;
        this.initializationTracker = initializationTracker;
    }

    protected void setBuckets(List<? extends Bucket> buckets) {
        this.initializationTracker.jobInitialized();
        for (int i = 0; i < this.pageBucketReceivers.size(); ++i) {
            PageBucketReceiver pageBucketReceiver = this.pageBucketReceivers.get(i);
            Bucket bucket = buckets.get(i);
            assert (bucket != null) : "buckets must contain a non-null bucket at idx=" + i;
            pageBucketReceiver.setBucket(this.bucketIdx, bucket, true, PagingUnsupportedResultListener.INSTANCE);
        }
    }

    protected void failed(@NotNull Throwable t) {
        this.initializationTracker.jobInitializationFailed(t);
        for (PageBucketReceiver pageBucketReceiver : this.pageBucketReceivers) {
            pageBucketReceiver.kill(t);
        }
    }

    private static class BucketForwardingActionListener
    implements ActionListener<JobResponse> {
        private final Streamer<?>[] responseDeserializer;
        private final BucketForwarder forwarder;

        BucketForwardingActionListener(Streamer<?>[] responseDeserializer, BucketForwarder forwarder) {
            this.responseDeserializer = responseDeserializer;
            this.forwarder = forwarder;
        }

        @Override
        public void onResponse(JobResponse jobResponse) {
            this.forwarder.setBuckets(jobResponse.getDirectResponses(this.responseDeserializer));
        }

        @Override
        public void onFailure(Exception e) {
            this.forwarder.failed(e);
        }
    }
}

