/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine;

import io.crate.data.Paging;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.Merge;
import io.crate.planner.UnionExecutionPlan;
import io.crate.planner.distribution.DistributionType;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.node.dql.CountPlan;
import io.crate.planner.node.dql.QueryThenFetch;
import io.crate.planner.node.dql.join.Join;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class NodeOperationTreeGenerator
extends ExecutionPlanVisitor<NodeOperationTreeContext, Void> {
    private static final NodeOperationTreeGenerator INSTANCE = new NodeOperationTreeGenerator();

    private NodeOperationTreeGenerator() {
    }

    public static NodeOperationTree fromPlan(ExecutionPlan executionPlan, String localNodeId) {
        NodeOperationTreeContext nodeOperationTreeContext = new NodeOperationTreeContext(localNodeId);
        INSTANCE.process(executionPlan, nodeOperationTreeContext);
        return new NodeOperationTree(nodeOperationTreeContext.nodeOperations(), nodeOperationTreeContext.root.phases.getFirst());
    }

    @Override
    public Void visitCountPlan(CountPlan plan, NodeOperationTreeContext context) {
        boolean useDirectResponse = context.noPreviousPhases();
        context.addPhase(plan.mergePhase());
        context.addPhase(plan.countPhase(), useDirectResponse);
        return null;
    }

    @Override
    public Void visitCollect(Collect plan, NodeOperationTreeContext context) {
        context.addPhase(plan.collectPhase());
        return null;
    }

    @Override
    public Void visitMerge(Merge merge, NodeOperationTreeContext context) {
        ExecutionPlan subExecutionPlan = merge.subPlan();
        boolean useDirectResponse = context.noPreviousPhases() && subExecutionPlan instanceof Collect && !Paging.shouldPage((int)subExecutionPlan.resultDescription().maxRowsPerNode());
        context.addPhase(merge.mergePhase());
        if (useDirectResponse) {
            context.addPhase(((Collect)subExecutionPlan).collectPhase(), true);
        } else {
            this.process(subExecutionPlan, context);
        }
        return null;
    }

    @Override
    public Void visitUnionPlan(UnionExecutionPlan unionExecutionPlan, NodeOperationTreeContext context) {
        context.addPhase(unionExecutionPlan.mergePhase());
        context.branch((byte)0);
        this.process(unionExecutionPlan.left(), context);
        context.leaveBranch();
        context.branch((byte)1);
        this.process(unionExecutionPlan.right(), context);
        context.leaveBranch();
        return null;
    }

    @Override
    public Void visitQueryThenFetch(QueryThenFetch node, NodeOperationTreeContext context) {
        this.process(node.subPlan(), context);
        context.addContextPhase(node.fetchPhase());
        return null;
    }

    @Override
    public Void visitJoin(Join plan, NodeOperationTreeContext context) {
        context.addPhase(plan.joinPhase());
        context.branch((byte)0);
        this.process(plan.left(), context);
        context.leaveBranch();
        context.branch((byte)1);
        this.process(plan.right(), context);
        context.leaveBranch();
        return null;
    }

    @Override
    protected Void visitPlan(ExecutionPlan executionPlan, NodeOperationTreeContext context) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Can't create NodeOperationTree from plan %s", executionPlan));
    }

    static class NodeOperationTreeContext {
        private final String localNodeId;
        private final List<NodeOperation> nodeOperations = new ArrayList<NodeOperation>();
        private final Deque<Branch> branches = new ArrayDeque<Branch>();
        private final Branch root;
        private Branch currentBranch;

        NodeOperationTreeContext(String localNodeId) {
            this.localNodeId = localNodeId;
            this.currentBranch = this.root = new Branch(0);
        }

        void addContextPhase(@Nullable ExecutionPhase executionPhase) {
            if (executionPhase != null) {
                this.nodeOperations.add(NodeOperation.withoutDownstream(executionPhase));
            }
        }

        void addPhase(@Nullable ExecutionPhase executionPhase) {
            this.addPhase(executionPhase, false);
        }

        void addPhase(@Nullable ExecutionPhase executionPhase, boolean directResponse) {
            byte inputId;
            ExecutionPhase previousPhase;
            if (executionPhase == null) {
                return;
            }
            if (this.branches.size() == 0 && this.currentBranch.phases.isEmpty()) {
                this.currentBranch.phases.add(executionPhase);
                return;
            }
            if (this.currentBranch.phases.isEmpty()) {
                previousPhase = this.branches.peekLast().phases.getLast();
                inputId = this.currentBranch.inputId;
            } else {
                previousPhase = this.currentBranch.phases.getLast();
                inputId = 0;
            }
            assert (this.saneConfiguration(executionPhase, previousPhase.nodeIds())) : String.format(Locale.ENGLISH, "NodeOperation with %s and %s as downstreams cannot work", ExecutionPhases.debugPrint(executionPhase), previousPhase.nodeIds());
            NodeOperation nodeOperation = directResponse ? NodeOperation.withDirectResponse(executionPhase, previousPhase, inputId, this.localNodeId) : NodeOperation.withDownstream(executionPhase, previousPhase, inputId);
            this.nodeOperations.add(nodeOperation);
            this.currentBranch.phases.add(executionPhase);
        }

        private boolean saneConfiguration(ExecutionPhase executionPhase, Collection<String> downstreamNodes) {
            if (executionPhase instanceof UpstreamPhase && ((UpstreamPhase)executionPhase).distributionInfo().distributionType() == DistributionType.SAME_NODE) {
                return downstreamNodes.isEmpty() || downstreamNodes.containsAll(executionPhase.nodeIds());
            }
            return true;
        }

        void branch(byte inputId) {
            this.branches.add(this.currentBranch);
            this.currentBranch = new Branch(inputId);
        }

        void leaveBranch() {
            this.currentBranch = this.branches.pollLast();
        }

        Collection<NodeOperation> nodeOperations() {
            return this.nodeOperations;
        }

        boolean noPreviousPhases() {
            return this.branches.isEmpty() && this.currentBranch.phases.isEmpty();
        }
    }

    private static class Branch {
        private final Deque<ExecutionPhase> phases = new ArrayDeque<ExecutionPhase>();
        private final byte inputId;

        Branch(byte inputId) {
            this.inputId = inputId;
        }
    }
}

