/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.types.DataType;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

public abstract class AggregationFunction<TPartial, TFinal>
implements FunctionImplementation {
    @Nullable
    public abstract TPartial newState(RamAccounting var1, Version var2, Version var3, MemoryManager var4);

    public abstract TPartial iterate(RamAccounting var1, MemoryManager var2, TPartial var3, Input<?> ... var4) throws CircuitBreakingException;

    public abstract TPartial reduce(RamAccounting var1, TPartial var2, TPartial var3);

    public abstract TFinal terminatePartial(RamAccounting var1, TPartial var2);

    public abstract DataType<?> partialType();

    public AggregationFunction<?, TFinal> optimizeForExecutionAsWindowFunction() {
        return this;
    }

    public boolean isRemovableCumulative() {
        return false;
    }

    public TPartial removeFromAggregatedState(RamAccounting ramAccounting, TPartial previousAggState, Input<?>[] stateToRemove) {
        throw new UnsupportedOperationException("Cannot remove state from the aggregated state as the function is not removable cumulative");
    }

    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        return null;
    }

    protected Reference getAggReference(List<Reference> aggregationReferences) {
        if (aggregationReferences.isEmpty()) {
            return null;
        }
        Reference reference = aggregationReferences.getFirst();
        if (reference == null) {
            return null;
        }
        if (!reference.hasDocValues() || reference.granularity() != RowGranularity.DOC) {
            return null;
        }
        return reference;
    }
}

