/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.PrimitiveMapWithNulls;
import io.crate.types.DataType;
import io.netty.util.collection.ByteObjectHashMap;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.ShortObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.lucene.util.RamUsageEstimator;

public final class GroupByMaps {
    public static <K, V> BiConsumer<Map<K, V>, K> accountForNewEntry(RamAccounting ramAccounting, DataType<K> type) {
        return (map, k) -> ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)(type.valueBytes(k) + 36L)));
    }

    public static <K, V> BiConsumer<Map<K, V>, K> accountForNewEntry(RamAccounting ramAccounting, List<? extends DataType> types) {
        return (map, k) -> {
            assert (k instanceof List) : "keys must be a list if there are multiple key types";
            long size = 0L;
            for (int i = 0; i < types.size(); ++i) {
                DataType dataType = (DataType)types.get(i);
                Object value = ((List)k).get(i);
                size += dataType.valueBytes(value);
            }
            ramAccounting.addBytes(RamUsageEstimator.alignObjectSize((long)(size + 36L)));
        };
    }

    public static <K, V> Supplier<Map<K, V>> mapForType(DataType<K> type) {
        switch (type.id()) {
            case 2: {
                return () -> new PrimitiveMapWithNulls(new ByteObjectHashMap());
            }
            case 8: {
                return () -> new PrimitiveMapWithNulls(new ShortObjectHashMap());
            }
            case 9: {
                return () -> new PrimitiveMapWithNulls(new IntObjectHashMap());
            }
            case 10: 
            case 11: 
            case 15: {
                return () -> new PrimitiveMapWithNulls(new LongObjectHashMap());
            }
        }
        return HashMap::new;
    }
}

