/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.execution.engine.aggregation.impl.CmpByAggregation;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CompareByType
extends DataType<CmpByAggregation.CompareBy>
implements Streamer<CmpByAggregation.CompareBy> {
    public static final int ID = 1027;
    private final DataType<?> retValType;
    private final DataType<?> cmpType;

    public CompareByType(DataType<?> retValType, DataType<?> cmpType) {
        this.retValType = retValType;
        this.cmpType = cmpType;
    }

    public CompareByType(StreamInput in) throws IOException {
        this.retValType = DataTypes.fromStream(in);
        this.cmpType = DataTypes.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.toStream(this.retValType, out);
        DataTypes.toStream(this.cmpType, out);
    }

    @Override
    public int compare(CmpByAggregation.CompareBy o1, CmpByAggregation.CompareBy o2) {
        return o1.cmpValue.compareTo(o2.cmpValue);
    }

    @Override
    public int id() {
        return 1027;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.UNDEFINED;
    }

    @Override
    public String getName() {
        return "_cmp_by_type";
    }

    @Override
    public Streamer<CmpByAggregation.CompareBy> streamer() {
        return this;
    }

    @Override
    public CmpByAggregation.CompareBy sanitizeValue(Object value) {
        return (CmpByAggregation.CompareBy)value;
    }

    @Override
    public CmpByAggregation.CompareBy readValueFrom(StreamInput in) throws IOException {
        Object retVal = this.retValType.streamer().readValueFrom(in);
        Object cmpVal = this.cmpType.streamer().readValueFrom(in);
        CmpByAggregation.CompareBy compareBy = new CmpByAggregation.CompareBy();
        compareBy.cmpValue = (Comparable)cmpVal;
        compareBy.resultValue = retVal;
        return compareBy;
    }

    @Override
    public void writeValueTo(StreamOutput out, CmpByAggregation.CompareBy v) throws IOException {
        this.retValType.streamer().writeValueTo(out, v.resultValue);
        this.cmpType.streamer().writeValueTo(out, v.cmpValue);
    }

    @Override
    public long valueBytes(CmpByAggregation.CompareBy value) {
        throw new UnsupportedOperationException("valueSize is not implemented for CompareByType");
    }
}

