/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public class GeometricMeanAggregation
extends AggregationFunction<GeometricMeanState, Double> {
    public static final String NAME = "geometric_mean";
    static final List<DataType<?>> SUPPORTED_TYPES;
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        for (DataType<?> supportedType : SUPPORTED_TYPES) {
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), GeometricMeanAggregation::new);
        }
    }

    public GeometricMeanAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @Nullable
    public GeometricMeanState newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)GeometricMeanStateType.INSTANCE.fixedSize());
        return new GeometricMeanState();
    }

    @Override
    public GeometricMeanState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, GeometricMeanState state, Input<?> ... args) throws CircuitBreakingException {
        Number value;
        if (state != null && (value = (Number)args[0].value()) != null) {
            state.addValue(value.doubleValue());
        }
        return state;
    }

    @Override
    public GeometricMeanState reduce(RamAccounting ramAccounting, GeometricMeanState state1, GeometricMeanState state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        state1.merge(state2);
        return state1;
    }

    @Override
    public Double terminatePartial(RamAccounting ramAccounting, GeometricMeanState state) {
        return state.value();
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public GeometricMeanState removeFromAggregatedState(RamAccounting ramAccounting, GeometricMeanState previousAggState, Input<?>[] stateToRemove) {
        Number value;
        if (previousAggState != null && (value = (Number)stateToRemove[0].value()) != null) {
            previousAggState.subValue(value.doubleValue());
        }
        return previousAggState;
    }

    @Override
    public DataType<?> partialType() {
        return GeometricMeanStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        if (!reference.hasDocValues()) {
            return null;
        }
        switch (reference.valueType().id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new SortedNumericDocValueAggregator<GeometricMeanState>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)GeometricMeanStateType.INSTANCE.fixedSize());
                    return new GeometricMeanState();
                }, (values, state) -> state.addValue(values.nextValue()));
            }
            case 7: {
                return new SortedNumericDocValueAggregator<GeometricMeanState>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)GeometricMeanStateType.INSTANCE.fixedSize());
                    return new GeometricMeanState();
                }, (values, state) -> {
                    float value = NumericUtils.sortableIntToFloat((int)((int)values.nextValue()));
                    state.addValue(value);
                });
            }
            case 6: {
                return new SortedNumericDocValueAggregator<GeometricMeanState>(reference.storageIdent(), (ramAccounting, memoryManager, minNodeVersion) -> {
                    ramAccounting.addBytes((long)GeometricMeanStateType.INSTANCE.fixedSize());
                    return new GeometricMeanState();
                }, (values, state) -> {
                    double value = NumericUtils.sortableLongToDouble((long)values.nextValue());
                    state.addValue(value);
                });
            }
        }
        return null;
    }

    static {
        DataTypes.register(4096, in -> GeometricMeanStateType.INSTANCE);
        SUPPORTED_TYPES = Lists.concat(DataTypes.NUMERIC_PRIMITIVE_TYPES, (Object)DataTypes.TIMESTAMPZ);
    }

    public static class GeometricMeanStateType
    extends DataType<GeometricMeanState>
    implements Streamer<GeometricMeanState>,
    FixedWidthType {
        public static final GeometricMeanStateType INSTANCE = new GeometricMeanStateType();
        public static final int ID = 4096;

        @Override
        public int id() {
            return 4096;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.UNDEFINED;
        }

        @Override
        public String getName() {
            return "geometric_mean_state";
        }

        @Override
        public Streamer<GeometricMeanState> streamer() {
            return this;
        }

        @Override
        public GeometricMeanState sanitizeValue(Object value) {
            return (GeometricMeanState)value;
        }

        @Override
        public int compare(GeometricMeanState val1, GeometricMeanState val2) {
            return val1.compareTo(val2);
        }

        @Override
        public int fixedSize() {
            return 40;
        }

        @Override
        public GeometricMeanState readValueFrom(StreamInput in) throws IOException {
            return new GeometricMeanState(in);
        }

        @Override
        public void writeValueTo(StreamOutput out, GeometricMeanState v) throws IOException {
            v.writeTo(out);
        }

        @Override
        public long valueBytes(GeometricMeanState value) {
            throw new UnsupportedOperationException("valueSize is not implemented for GeometricMeanStateType");
        }
    }

    public static class GeometricMeanState
    implements Comparable<GeometricMeanState>,
    Writeable {
        private long n;
        private double value;

        public GeometricMeanState() {
            this.value = 0.0;
            this.n = 0L;
        }

        public GeometricMeanState(StreamInput in) throws IOException {
            this.n = in.readVLong();
            this.value = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.n);
            out.writeDouble(this.value);
        }

        private void addValue(double val) {
            this.value += FastMath.log((double)val);
            ++this.n;
        }

        private void subValue(double val) {
            this.value -= FastMath.log((double)val);
            --this.n;
        }

        private Double value() {
            if (this.n > 0L) {
                return FastMath.exp((double)(this.value / (double)this.n));
            }
            return null;
        }

        private void merge(GeometricMeanState other) {
            this.value += other.value;
            this.n += other.n;
        }

        @Override
        public int compareTo(GeometricMeanState o) {
            return Comparator.comparing(GeometricMeanState::value).thenComparing(x -> x.n).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeometricMeanState that = (GeometricMeanState)o;
            return Objects.equals(this.value(), that.value());
        }

        public int hashCode() {
            return Objects.hash(this.value());
        }
    }
}

