/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.BinaryDocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.statistics.SketchStreamer;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.frequencies.LongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public class TopKAggregation
extends AggregationFunction<State, Map<String, Object>> {
    public static final String NAME = "topk";
    static final Signature DEFAULT_SIGNATURE = Signature.builder("topk", FunctionType.AGGREGATE).argumentTypes(TypeSignature.parse("V")).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("V")).build();
    static final Signature LIMIT_SIGNATURE = Signature.builder("topk", FunctionType.AGGREGATE).argumentTypes(TypeSignature.parse("V"), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("V")).build();
    static final Signature LIMIT_CAPACITY_SIGNATURE = Signature.builder("topk", FunctionType.AGGREGATE).argumentTypes(TypeSignature.parse("V"), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("V")).build();
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final DataType<?> argumentType;
    private static final int DEFAULT_LIMIT = 8;
    private static final int MAX_LIMIT = 5000;
    private static final int DEFAULT_MAX_CAPACITY = 8192;

    public static void register(Functions.Builder builder) {
        builder.add(DEFAULT_SIGNATURE, TopKAggregation::new);
        builder.add(LIMIT_SIGNATURE, TopKAggregation::new);
        builder.add(LIMIT_CAPACITY_SIGNATURE, TopKAggregation::new);
    }

    private TopKAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        DataType<?> type = boundSignature.argTypes().getFirst();
        if (type instanceof StateType) {
            StateType st = (StateType)type;
            this.argumentType = st.innerType;
        } else {
            this.argumentType = type;
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public State newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        return State.EMPTY;
    }

    @Override
    public State iterate(RamAccounting ramAccounting, MemoryManager memoryManager, State state, Input<?> ... args) throws CircuitBreakingException {
        Object value = args[0].value();
        if (state instanceof Empty) {
            if (args.length == 3) {
                Integer limit = (Integer)args[1].value();
                Integer capacity = (Integer)args[2].value();
                state = this.initState(ramAccounting, limit, capacity);
            } else if (args.length == 2) {
                Integer limit = (Integer)args[1].value();
                state = this.initState(ramAccounting, limit, 8192);
            } else if (args.length == 1) {
                state = this.initState(ramAccounting, 8, 8192);
            }
        }
        state.update(value, this.argumentType);
        return state;
    }

    private static long calculateRamUsage(long maxMapSize) {
        return maxMapSize * 18L;
    }

    @Override
    public State reduce(RamAccounting ramAccounting, State state1, State state2) {
        return state1.merge(state2);
    }

    @Override
    public Map<String, Object> terminatePartial(RamAccounting ramAccounting, State state) {
        return state.result(this.argumentType);
    }

    @Override
    public DataType<?> partialType() {
        return new StateType(this.argumentType);
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        if (optionalParams.isEmpty()) {
            return this.getDocValueAggregator(reference, 8, 8192);
        }
        if (optionalParams.size() == 1 && optionalParams.getFirst() == null) {
            return this.getDocValueAggregator(reference, 8, 8192);
        }
        if (optionalParams.size() == 2) {
            Literal<?> limitLiteral = optionalParams.getLast();
            int limit = limitLiteral == null ? 8 : (Integer)limitLiteral.value();
            return this.getDocValueAggregator(reference, limit, 8192);
        }
        if (optionalParams.size() == 3) {
            Literal<?> limitLiteral = optionalParams.get(1);
            Literal<?> capacityLiteral = optionalParams.get(2);
            int limit = limitLiteral == null ? 8 : (Integer)limitLiteral.value();
            int capacity = capacityLiteral == null ? 8192 : (Integer)capacityLiteral.value();
            return this.getDocValueAggregator(reference, limit, capacity);
        }
        return null;
    }

    @Nullable
    private DocValueAggregator<?> getDocValueAggregator(Reference ref, int limit, int capacity) {
        DataType<?> type = ref.valueType();
        if (TopKAggregation.supportedByLongSketch(type)) {
            return new SortedNumericDocValueAggregator<TopKLongState>(ref.storageIdent(), (ramAccounting, memoryManager, version) -> this.topKLongState((RamAccounting)ramAccounting, limit, capacity), (values, state) -> state.update(values.nextValue(), type));
        }
        if (type.id() == 4) {
            return new BinaryDocValueAggregator<TopKState>(ref.storageIdent(), (ramAccounting, memoryManager, version) -> this.topKState((RamAccounting)ramAccounting, limit, capacity), (values, state) -> {
                long ord = values.nextOrd();
                BytesRef value = values.lookupOrd(ord);
                state.update(value.utf8ToString(), type);
            });
        }
        if (type.id() == 5) {
            return new BinaryDocValueAggregator<TopKState>(ref.storageIdent(), (ramAccounting, memoryManager, version) -> this.topKState((RamAccounting)ramAccounting, limit, capacity), (values, state) -> {
                long ord = values.nextOrd();
                BytesRef value = values.lookupOrd(ord);
                state.update(NetworkUtils.formatIPBytes(value), type);
            });
        }
        return null;
    }

    private static boolean supportedByLongSketch(DataType<?> type) {
        return switch (type.id()) {
            case 2, 6, 7, 8, 9, 10, 11, 15 -> true;
            default -> false;
        };
    }

    private State initState(RamAccounting ramAccounting, int limit, int capacity) {
        if (limit <= 0 || limit > 5000) {
            throw new IllegalArgumentException("Limit parameter for topk must be between 0 and 10_000. Got: " + limit);
        }
        if (!Util.isIntPowerOf2((int)capacity)) {
            throw new IllegalArgumentException("Capacity parameter must be a positive integer-power of 2. Got: " + capacity);
        }
        if (limit >= capacity) {
            throw new IllegalArgumentException("Limit parameter for topk must be less than capacity parameter. Got limit: " + limit + " capacity: " + capacity);
        }
        if (TopKAggregation.supportedByLongSketch(this.argumentType)) {
            return this.topKLongState(ramAccounting, limit, capacity);
        }
        return this.topKState(ramAccounting, limit, capacity);
    }

    private TopKState topKState(RamAccounting ramAccounting, int limit, int capacity) {
        ramAccounting.addBytes(TopKAggregation.calculateRamUsage(capacity) + TopKState.SHALLOW_SIZE);
        return new TopKState((ItemsSketch<Object>)new ItemsSketch(capacity), limit);
    }

    private TopKLongState topKLongState(RamAccounting ramAccounting, int limit, int capacity) {
        ramAccounting.addBytes(TopKAggregation.calculateRamUsage(capacity) + TopKLongState.SHALLOW_SIZE);
        return new TopKLongState(new LongsSketch(capacity), limit);
    }

    static {
        DataTypes.register(4232, StateType::new);
    }

    static final class StateType
    extends DataType<State>
    implements Streamer<State> {
        public static final int ID = 4232;
        private final DataType<?> innerType;

        public StateType(DataType<?> innerType) {
            this.innerType = innerType;
        }

        public StateType(StreamInput streamInput) throws IOException {
            this.innerType = DataTypes.fromStream(streamInput);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            DataTypes.toStream(this.innerType, out);
        }

        @Override
        public int id() {
            return 4232;
        }

        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public String getName() {
            return "topk_state";
        }

        @Override
        public Streamer<State> streamer() {
            return this;
        }

        @Override
        public State sanitizeValue(Object value) {
            return (State)value;
        }

        @Override
        public State readValueFrom(StreamInput in) throws IOException {
            return State.fromStream(in, this.innerType);
        }

        @Override
        public void writeValueTo(StreamOutput out, State state) throws IOException {
            state.writeTo(out, this.innerType);
        }

        @Override
        public long valueBytes(State value) {
            throw new UnsupportedOperationException("valueSize is not implemented for TopKStateType");
        }

        @Override
        public int compare(State s1, State s2) {
            return 0;
        }
    }

    static sealed interface State
    permits Empty, TopKState, TopKLongState {
        public static final Empty EMPTY = new Empty();

        public Map<String, Object> result(DataType<?> var1);

        public State merge(State var1);

        public void update(Object var1, DataType<?> var2);

        public void update(long var1, DataType<?> var3);

        public void writeTo(StreamOutput var1, DataType<?> var2) throws IOException;

        public static State fromStream(StreamInput in, DataType<?> innerType) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return new TopKState(in, innerType);
                }
                case 2: {
                    return new TopKLongState(in);
                }
            }
            return EMPTY;
        }
    }

    static final class Empty
    implements State {
        static final int ID = 0;

        Empty() {
        }

        @Override
        public Map<String, Object> result(DataType<?> datatype) {
            return Map.of();
        }

        @Override
        public State merge(State other) {
            return other;
        }

        @Override
        public void update(Object value, DataType<?> dataType) {
            throw new UnsupportedOperationException("Empty state does not support updates");
        }

        @Override
        public void update(long value, DataType<?> dataType) {
            throw new UnsupportedOperationException("Empty state does not support updates");
        }

        @Override
        public void writeTo(StreamOutput out, DataType<?> innerType) throws IOException {
            out.writeByte((byte)0);
        }
    }

    static final class TopKLongState
    implements State {
        static long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TopKLongState.class);
        static final int ID = 2;
        private final LongsSketch sketch;
        private final int limit;

        TopKLongState(LongsSketch sketch, int limit) {
            this.sketch = sketch;
            this.limit = limit;
        }

        TopKLongState(StreamInput in) throws IOException {
            this.limit = in.readInt();
            this.sketch = LongsSketch.getInstance((Memory)Memory.wrap((byte[])in.readByteArray()));
        }

        @Override
        public Map<String, Object> result(DataType<?> dataType) {
            if (this.sketch.isEmpty()) {
                return Map.of();
            }
            LongsSketch.Row[] frequentItems = this.sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            int limit = Math.min(frequentItems.length, this.limit);
            ArrayList<Map<String, Long>> frequencies = new ArrayList<Map<String, Long>>();
            for (int i = 0; i < limit; ++i) {
                LongsSketch.Row item = frequentItems[i];
                frequencies.add(Map.of("item", TopKLongState.toObject(dataType, item.getItem()), "estimate", item.getEstimate(), "lower_bound", item.getLowerBound(), "upper_bound", item.getUpperBound()));
            }
            return Map.of("maximum_error", this.sketch.getMaximumError(), "frequencies", frequencies);
        }

        @Override
        public State merge(State other) {
            if (other instanceof Empty) {
                return this;
            }
            if (other instanceof TopKLongState) {
                TopKLongState otherTopK = (TopKLongState)other;
                return new TopKLongState(this.sketch.merge(otherTopK.sketch), this.limit);
            }
            throw new IllegalArgumentException("Cannot merge state");
        }

        @Override
        public void update(Object value, DataType<?> dataType) {
            this.sketch.update(TopKLongState.toLong(dataType, value));
        }

        @Override
        public void update(long value, DataType<?> dataType) {
            this.sketch.update(value);
        }

        @Override
        public void writeTo(StreamOutput out, DataType<?> innerType) throws IOException {
            out.writeByte((byte)2);
            out.writeInt(this.limit);
            out.writeByteArray(this.sketch.toByteArray());
        }

        private static long toLong(DataType<?> type, Object o) {
            return switch (type.id()) {
                case 10, 11, 15 -> (Long)o;
                case 6 -> NumericUtils.doubleToSortableLong((double)((Double)o));
                case 7 -> NumericUtils.floatToSortableInt((float)((Float)o).floatValue());
                case 9 -> ((Integer)o).longValue();
                case 8 -> ((Short)o).longValue();
                case 2 -> ((Byte)o).longValue();
                default -> throw new IllegalArgumentException("Type cannot be converted to long");
            };
        }

        private static Object toObject(DataType<?> type, long o) {
            return switch (type.id()) {
                case 10, 11, 15 -> o;
                case 6 -> NumericUtils.sortableLongToDouble((long)o);
                case 7 -> Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)o)));
                case 9 -> (int)o;
                case 8 -> (short)o;
                case 2 -> (byte)o;
                default -> throw new IllegalArgumentException("Long value cannot be converted");
            };
        }
    }

    static final class TopKState
    implements State {
        static long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(TopKState.class);
        static final int ID = 1;
        private final ItemsSketch<Object> sketch;
        private final int limit;

        TopKState(ItemsSketch<Object> sketch, int limit) {
            this.sketch = sketch;
            this.limit = limit;
        }

        TopKState(StreamInput in, DataType<?> innerType) throws IOException {
            this.limit = in.readInt();
            SketchStreamer streamer = new SketchStreamer(innerType.streamer());
            this.sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])in.readByteArray()), streamer);
        }

        @Override
        public Map<String, Object> result(DataType<?> dataType) {
            if (this.sketch.isEmpty()) {
                return Map.of();
            }
            ItemsSketch.Row[] frequentItems = this.sketch.getFrequentItems(ErrorType.NO_FALSE_NEGATIVES);
            int limit = Math.min(frequentItems.length, this.limit);
            ArrayList<Map<String, Long>> frequencies = new ArrayList<Map<String, Long>>(limit);
            for (int i = 0; i < limit; ++i) {
                ItemsSketch.Row item = frequentItems[i];
                frequencies.add(Map.of("item", item.getItem(), "estimate", item.getEstimate(), "lower_bound", item.getLowerBound(), "upper_bound", item.getUpperBound()));
            }
            return Map.of("maximum_error", this.sketch.getMaximumError(), "frequencies", frequencies);
        }

        @Override
        public State merge(State other) {
            if (other instanceof Empty) {
                return this;
            }
            if (other instanceof TopKState) {
                TopKState otherTopk = (TopKState)other;
                return new TopKState((ItemsSketch<Object>)this.sketch.merge(otherTopk.sketch), this.limit);
            }
            throw new IllegalArgumentException("Cannot merge state");
        }

        @Override
        public void update(Object value, DataType<?> dataType) {
            this.sketch.update(value);
        }

        @Override
        public void update(long value, DataType<?> dataType) {
            this.sketch.update((Object)value);
        }

        @Override
        public void writeTo(StreamOutput out, DataType<?> innerType) throws IOException {
            out.writeByte((byte)1);
            out.writeInt(this.limit);
            SketchStreamer streamer = new SketchStreamer(innerType.streamer());
            out.writeByteArray(this.sketch.toByteArray(streamer));
        }
    }
}

