/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.average.numeric;

import io.crate.execution.engine.aggregation.impl.util.NumericValueHolder;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NumericAverageState<T extends NumericValueHolder>
implements Comparable<NumericAverageState<T>> {
    @NotNull
    T sum;
    long count;

    NumericAverageState(T initialValue, long count) {
        this.sum = initialValue;
        this.count = count;
    }

    public BigDecimal value() {
        if (this.count > 0L) {
            return this.sum.value().divide(BigDecimal.valueOf(this.count), MathContext.DECIMAL128);
        }
        return null;
    }

    @Override
    public int compareTo(NumericAverageState<T> o) {
        if (o == null) {
            return 1;
        }
        int compare = Long.compare(this.count, o.count);
        if (compare == 0) {
            return this.sum.value().compareTo(o.sum.value());
        }
        return compare;
    }

    public String toString() {
        return "sum: " + String.valueOf(this.sum) + " count: " + this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericAverageState that = (NumericAverageState)o;
        return this.count == that.count && this.sum.value().equals(that.value());
    }

    public int hashCode() {
        return Objects.hash(this.count, this.sum);
    }
}

