/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.util;

import io.crate.execution.engine.aggregation.impl.util.NumericValueHolder;
import java.math.BigDecimal;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class OverflowAwareMutableLong
implements NumericValueHolder {
    private long primitiveSum;
    private BigDecimal bigDecimalSum = BigDecimal.ZERO;
    private boolean hasValue;

    public OverflowAwareMutableLong(long value) {
        this.primitiveSum = value;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @VisibleForTesting
    long primitiveSum() {
        return this.primitiveSum;
    }

    @Nullable
    @VisibleForTesting
    BigDecimal bigDecimalSum() {
        return this.bigDecimalSum;
    }

    public void add(long value) {
        this.hasValue = true;
        long newSum = this.primitiveSum + value;
        if (((this.primitiveSum ^ newSum) & (value ^ newSum)) < 0L) {
            this.bigDecimalSum = this.bigDecimalSum.add(BigDecimal.valueOf(this.primitiveSum)).add(BigDecimal.valueOf(value));
            this.primitiveSum = 0L;
        } else {
            this.primitiveSum += value;
        }
    }

    @Override
    public BigDecimal value() {
        return this.bigDecimalSum.add(BigDecimal.valueOf(this.primitiveSum));
    }

    @Override
    public void setValue(BigDecimal value) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }
}

