/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.statistics;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class Variance
implements Writeable,
Comparable<Variance> {
    public static final int FIXED_SIZE = 192;
    private double sumOfSqrs;
    private double sum;
    private long count;

    public Variance() {
        this.sumOfSqrs = 0.0;
        this.sum = 0.0;
        this.count = 0L;
    }

    public Variance(StreamInput in) throws IOException {
        this.sumOfSqrs = in.readDouble();
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sumOfSqrs);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    public void increment(double value) {
        this.sumOfSqrs += value * value;
        this.sum += value;
        ++this.count;
    }

    public void decrement(double value) {
        this.sumOfSqrs -= value * value;
        this.sum -= value;
        --this.count;
    }

    public double result() {
        if (this.count == 0L) {
            return Double.NaN;
        }
        return (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)this.count;
    }

    public void merge(Variance other) {
        this.sumOfSqrs += other.sumOfSqrs;
        this.sum += other.sum;
        this.count += other.count;
    }

    @Override
    public int compareTo(Variance o) {
        return Double.compare(this.result(), o.result());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variance variance = (Variance)o;
        return Objects.equals(variance.result(), this.result());
    }

    public int hashCode() {
        return Objects.hash(this.result());
    }
}

