/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;

public final class RowCollectExpression
implements CollectExpression<Row, Object> {
    private final int index;
    private Object value;

    public RowCollectExpression(int index) {
        this.index = index;
    }

    @Override
    public void setNextRow(Row row) {
        assert (row.numColumns() > this.index) : "Wanted to retrieve value for column at position=" + this.index + " from row=" + String.valueOf(row) + " but row has only " + row.numColumns() + " columns";
        this.value = row.get(this.index);
    }

    public Object value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCollectExpression that = (RowCollectExpression)o;
        if (this.index != that.index) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RowCollectExpression{idx=" + this.index + "}";
    }
}

