/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.data.RowConsumer;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.distribution.merge.PassThroughPagingIterator;
import io.crate.execution.jobs.CumulativePageBucketReceiver;
import io.crate.execution.jobs.DistResultRXTask;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.jobs.transport.JobRequest;
import io.crate.execution.jobs.transport.JobResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import io.crate.metadata.settings.SessionSettings;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RemoteCollector {
    private static final Logger LOGGER = LogManager.getLogger(RemoteCollector.class);
    private static final int RECEIVER_PHASE_ID = 1;
    private final UUID jobId;
    private final SessionSettings sessionSettings;
    private final String localNode;
    private final String remoteNode;
    private final Executor executor;
    private final ActionExecutor<NodeRequest<JobRequest>, JobResponse> jobAction;
    private final ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction;
    private final TasksService tasksService;
    private final RamAccounting ramAccounting;
    private final RowConsumer consumer;
    private final RoutedCollectPhase collectPhase;
    private final Object killLock = new Object();
    private final boolean scrollRequired;
    private final boolean enableProfiling;
    private RootTask context = null;
    private boolean collectorKilled = false;

    public RemoteCollector(UUID jobId, SessionSettings sessionSettings, String localNode, String remoteNode, ActionExecutor<NodeRequest<JobRequest>, JobResponse> jobAction, ActionExecutor<KillJobsNodeRequest, KillResponse> killNodeAction, Executor executor, TasksService tasksService, RamAccounting ramAccounting, RowConsumer consumer, RoutedCollectPhase collectPhase) {
        this.jobId = jobId;
        this.sessionSettings = sessionSettings;
        this.localNode = localNode;
        this.remoteNode = remoteNode;
        this.executor = executor;
        this.enableProfiling = false;
        this.scrollRequired = consumer.requiresScroll();
        this.jobAction = jobAction;
        this.killNodeAction = killNodeAction;
        this.tasksService = tasksService;
        this.ramAccounting = ramAccounting;
        this.consumer = consumer;
        this.collectPhase = collectPhase;
    }

    public void doCollect() {
        if (!this.createLocalContext()) {
            return;
        }
        this.createRemoteContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean createLocalContext() {
        RootTask.Builder builder = this.createPageDownstreamContext();
        try {
            Object object = this.killLock;
            synchronized (object) {
                if (this.collectorKilled) {
                    this.consumer.accept(null, (Throwable)new InterruptedException());
                    return false;
                }
                this.context = this.tasksService.createTask(builder);
                this.context.start();
                return true;
            }
        }
        catch (Throwable t) {
            if (this.context == null) {
                this.consumer.accept(null, t);
            } else {
                this.context.kill(t.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createRemoteContext() {
        NodeOperation nodeOperation = new NodeOperation(this.collectPhase, Collections.singletonList(this.localNode), 1, 0);
        Object object = this.killLock;
        synchronized (object) {
            if (this.collectorKilled) {
                this.context.kill(null);
                return;
            }
            this.jobAction.execute(JobRequest.of(this.remoteNode, this.jobId, this.sessionSettings, this.localNode, Collections.singletonList(nodeOperation), this.enableProfiling)).whenComplete((resp, t) -> {
                if (t == null) {
                    LOGGER.trace("RemoteCollector jobId={} jobAction=onResponse collectorKilled={}", (Object)this.jobId, (Object)this.collectorKilled);
                    if (this.collectorKilled) {
                        this.killRemoteContext();
                    }
                } else {
                    LOGGER.error("RemoteCollector jobId={} jobAction=onFailure collectorKilled={} error={}", (Object)this.jobId, (Object)this.collectorKilled, t);
                    this.context.kill(t.getMessage());
                }
            });
        }
    }

    private RootTask.Builder createPageDownstreamContext() {
        RootTask.Builder builder = this.tasksService.newBuilder(this.jobId, this.sessionSettings.userName(), this.localNode, Collections.emptySet());
        PassThroughPagingIterator<Integer, Object> pagingIterator = this.scrollRequired ? PassThroughPagingIterator.repeatable() : PassThroughPagingIterator.oneShot();
        CumulativePageBucketReceiver pageBucketReceiver = new CumulativePageBucketReceiver(this.localNode, 1, this.executor, DataTypes.getStreamers(this.collectPhase.outputTypes()), this.consumer, pagingIterator, 1);
        builder.addTask(new DistResultRXTask(1, "RemoteCollectPhase", pageBucketReceiver, this.ramAccounting, 1));
        return builder;
    }

    private void killRemoteContext() {
        KillJobsNodeRequest killRequest = new KillJobsNodeRequest(List.of(), List.of(this.jobId), this.sessionSettings.userName(), null);
        this.killNodeAction.execute(killRequest).whenComplete((resp, t) -> {
            if (t == null) {
                this.context.kill(null);
            } else {
                this.context.kill(t.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(@Nullable Throwable throwable) {
        Object object = this.killLock;
        synchronized (object) {
            this.collectorKilled = true;
        }
    }
}

