/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.execution.engine.collect.files.FileInput;
import io.crate.execution.engine.collect.files.FileReadingIterator;
import io.crate.execution.engine.collect.files.Globs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class LocalFsFileInput
implements FileInput {
    private static final Pattern HAS_GLOBS_PATTERN = Pattern.compile("^((file://|/)[^\\*]*/)[^\\*]*\\*.*");
    @NotNull
    private final URI uri;
    @Nullable
    @VisibleForTesting
    final URI preGlobUri;
    @NotNull
    private final Predicate<String> uriPredicate;

    public LocalFsFileInput(URI uri) throws IOException {
        Matcher hasGlobMatcher = HAS_GLOBS_PATTERN.matcher(uri.toString());
        if (hasGlobMatcher.matches()) {
            Path oldPath = Paths.get(FileReadingIterator.toURI(hasGlobMatcher.group(1)));
            String oldPathAsString = oldPath.toUri().toString();
            String newPathAsString = oldPath.toRealPath(new LinkOption[0]).toUri().toString();
            String resolvedFileUrl = uri.toString().replace(oldPathAsString, newPathAsString);
            this.uri = FileReadingIterator.toURI(resolvedFileUrl);
            this.preGlobUri = FileReadingIterator.toURI(newPathAsString);
        } else {
            this.uri = uri;
            this.preGlobUri = null;
        }
        this.uriPredicate = new Globs.GlobPredicate(this.uri.toString());
    }

    @Override
    public boolean isGlobbed() {
        return this.preGlobUri != null;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public List<URI> expandUri() throws IOException {
        if (this.preGlobUri == null) {
            return List.of(this.uri);
        }
        Path preGlobPath = Paths.get(this.preGlobUri);
        if (!Files.isDirectory(preGlobPath, new LinkOption[0]) && (preGlobPath = preGlobPath.getParent()) == null) {
            return List.of();
        }
        if (Files.notExists(preGlobPath, new LinkOption[0])) {
            return List.of();
        }
        final int fileURIDepth = LocalFsFileInput.countOccurrences(this.uri.toString(), '/');
        int maxDepth = fileURIDepth - LocalFsFileInput.countOccurrences(this.preGlobUri.toString(), '/') + 1;
        final ArrayList<URI> uris = new ArrayList<URI>();
        SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(this){
            final /* synthetic */ LocalFsFileInput this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    return FileVisitResult.CONTINUE;
                }
                if (exc instanceof FileSystemLoopException) {
                    int maxDepth = fileURIDepth - LocalFsFileInput.countOccurrences(file.toUri().toString(), '/') + 1;
                    if (maxDepth >= 0) {
                        Files.walkFileTree(file, EnumSet.of(FileVisitOption.FOLLOW_LINKS), maxDepth, this);
                    }
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                URI uri = file.toUri();
                if (this.this$0.uriPredicate.test(uri.toString())) {
                    uris.add(uri);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(preGlobPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)fileVisitor);
        return uris;
    }

    @Override
    public InputStream getStream(URI uri) throws IOException {
        File file = new File(uri);
        return new FileInputStream(file);
    }

    @Override
    public boolean sharedStorageDefault() {
        return false;
    }

    private static int countOccurrences(String str, char c) throws IOException {
        try {
            return Math.toIntExact(str.chars().filter(ch -> ch == c).count());
        }
        catch (ArithmeticException e) {
            throw new IOException("Provided URI is too long");
        }
    }
}

