/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.execution.engine.collect.files.SqlFeatureContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;

public final class SqlFeatures {
    private static final int NUM_COLS = 7;

    public static Iterable<SqlFeatureContext> loadFeatures() throws IOException {
        try (InputStream sqlFeatures = SqlFeatures.class.getResourceAsStream("/sql_features.tsv");){
            if (sqlFeatures == null) {
                throw new ResourceNotFoundException("sql_features.tsv file not found", new Object[0]);
            }
            ArrayList<SqlFeatureContext> featuresList = new ArrayList<SqlFeatureContext>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(sqlFeatures, StandardCharsets.UTF_8));){
                String next;
                while ((next = reader.readLine()) != null) {
                    List<String> parts = List.of(next.split("\t", 7));
                    SqlFeatureContext ctx = new SqlFeatureContext(parts.get(0), parts.get(1), parts.get(2), parts.get(3), parts.get(4).equals("YES"), parts.get(5).isEmpty() ? null : parts.get(5), parts.get(6).isEmpty() ? null : parts.get(6));
                    featuresList.add(ctx);
                }
            }
            ArrayList<SqlFeatureContext> arrayList = featuresList;
            return arrayList;
        }
    }
}

