/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.TableRelation;
import io.crate.common.collections.BlockingEvictingQueue;
import io.crate.common.unit.TimeValue;
import io.crate.data.Input;
import io.crate.execution.engine.collect.stats.FilteredLogSink;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.engine.collect.stats.LogSink;
import io.crate.execution.engine.collect.stats.NoopLogSink;
import io.crate.execution.engine.collect.stats.QueueSink;
import io.crate.execution.engine.collect.stats.RamAccountingQueue;
import io.crate.execution.engine.collect.stats.TimeBasedQEviction;
import io.crate.expression.ExpressionsInput;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.expression.reference.sys.job.ContextLog;
import io.crate.expression.reference.sys.job.JobContextLog;
import io.crate.expression.reference.sys.operation.OperationContextLog;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.SystemTable;
import io.crate.metadata.sys.SysJobsLogTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.parser.SqlParser;
import io.crate.types.DataTypes;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class JobsLogService
extends AbstractLifecycleComponent
implements Provider<JobsLogs> {
    public static final Setting<Boolean> STATS_ENABLED_SETTING = Setting.boolSetting("stats.enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<Integer> STATS_JOBS_LOG_SIZE_SETTING = Setting.intSetting("stats.jobs_log_size", 10000, 0, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<TimeValue> STATS_JOBS_LOG_EXPIRATION_SETTING = Setting.timeSetting("stats.jobs_log_expiration", TimeValue.timeValueSeconds((long)0L), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    private static final FilterValidator FILTER_VALIDATOR = new FilterValidator();
    public static final Setting<String> STATS_JOBS_LOG_FILTER = new Setting<String>("stats.jobs_log_filter", "true", Function.identity(), FILTER_VALIDATOR, DataTypes.STRING, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<String> STATS_JOBS_LOG_PERSIST_FILTER = new Setting<String>("stats.jobs_log_persistent_filter", "false", Function.identity(), FILTER_VALIDATOR, DataTypes.STRING, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<Integer> STATS_OPERATIONS_LOG_SIZE_SETTING = Setting.intSetting("stats.operations_log_size", 10000, 0, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<TimeValue> STATS_OPERATIONS_LOG_EXPIRATION_SETTING = Setting.timeSetting("stats.operations_log_expiration", TimeValue.timeValueSeconds((long)0L), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final CircuitBreakerService breakerService;
    private final InputFactory inputFactory;
    private final StaticTableReferenceResolver<JobContextLog> refResolver;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final CoordinatorTxnCtx systemTransactionCtx;
    private JobsLogs jobsLogs;
    private ExpressionsInput<JobContextLog, Boolean> memoryFilter;
    private ExpressionsInput<JobContextLog, Boolean> persistFilter;
    private volatile boolean isEnabled;
    volatile int jobsLogSize;
    volatile TimeValue jobsLogExpiration;
    volatile int operationsLogSize;
    volatile TimeValue operationsLogExpiration;

    public JobsLogService(Settings settings, ClusterService clusterService, NodeContext nodeCtx, CircuitBreakerService breakerService) {
        this.breakerService = breakerService;
        this.inputFactory = new InputFactory(nodeCtx);
        SystemTable<JobContextLog> jobsLogTable = SysJobsLogTableInfo.create(clusterService::localNode);
        this.refResolver = new StaticTableReferenceResolver<JobContextLog>(jobsLogTable.expressions());
        TableRelation sysJobsLogRelation = new TableRelation(jobsLogTable);
        this.systemTransactionCtx = CoordinatorTxnCtx.systemTransactionContext();
        this.expressionAnalyzer = new ExpressionAnalyzer(this.systemTransactionCtx, nodeCtx, ParamTypeHints.EMPTY, new NameFieldProvider(sysJobsLogRelation), null, Operation.READ);
        JobsLogService.FILTER_VALIDATOR.validate = this::asSymbol;
        this.isEnabled = STATS_ENABLED_SETTING.get(settings);
        this.jobsLogs = new JobsLogs(this::isEnabled);
        this.memoryFilter = this.createFilter(STATS_JOBS_LOG_FILTER.get(settings), STATS_JOBS_LOG_FILTER.getKey());
        this.persistFilter = this.createFilter(STATS_JOBS_LOG_PERSIST_FILTER.get(settings), STATS_JOBS_LOG_PERSIST_FILTER.getKey());
        this.setJobsLogSink(STATS_JOBS_LOG_SIZE_SETTING.get(settings), STATS_JOBS_LOG_EXPIRATION_SETTING.get(settings));
        this.setOperationsLogSink(STATS_OPERATIONS_LOG_SIZE_SETTING.get(settings), STATS_OPERATIONS_LOG_EXPIRATION_SETTING.get(settings));
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(STATS_JOBS_LOG_FILTER, filter -> {
            this.memoryFilter = this.createFilter((String)filter, STATS_JOBS_LOG_FILTER.getKey());
            this.updateJobSink(this.jobsLogSize, this.jobsLogExpiration);
        });
        clusterSettings.addSettingsUpdateConsumer(STATS_JOBS_LOG_PERSIST_FILTER, filter -> {
            this.persistFilter = this.createFilter((String)filter, STATS_JOBS_LOG_PERSIST_FILTER.getKey());
            this.updateJobSink(this.jobsLogSize, this.jobsLogExpiration);
        });
        clusterSettings.addSettingsUpdateConsumer(STATS_ENABLED_SETTING, this::setStatsEnabled);
        clusterSettings.addSettingsUpdateConsumer(STATS_JOBS_LOG_SIZE_SETTING, STATS_JOBS_LOG_EXPIRATION_SETTING, this::setJobsLogSink);
        clusterSettings.addSettingsUpdateConsumer(STATS_OPERATIONS_LOG_SIZE_SETTING, STATS_OPERATIONS_LOG_EXPIRATION_SETTING, this::setOperationsLogSink);
    }

    private Symbol asSymbol(String expression) {
        try {
            return this.expressionAnalyzer.convert(SqlParser.createExpression((String)expression), new ExpressionAnalysisContext(this.systemTransactionCtx.sessionSettings()));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Invalid filter expression: " + expression + ": " + t.getMessage(), t);
        }
    }

    private ExpressionsInput<JobContextLog, Boolean> createFilter(String filterExpression, String settingName) {
        Symbol filter = this.asSymbol(filterExpression);
        if (!filter.valueType().equals(DataTypes.BOOLEAN)) {
            throw new IllegalArgumentException("Filter expression for " + settingName + " must result in a boolean, not: " + String.valueOf(filter.valueType()) + " (`" + String.valueOf(filter) + "`)");
        }
        InputFactory.Context<JobContextLog> ctx = this.inputFactory.ctxForRefs(this.systemTransactionCtx, this.refResolver);
        Input<?> filterInput = ctx.add(filter);
        return new ExpressionsInput<JobContextLog, Boolean>(filterInput, ctx.expressions());
    }

    private void setJobsLogSink(int size, TimeValue expiration) {
        this.jobsLogSize = size;
        this.jobsLogExpiration = expiration;
        if (!this.isEnabled) {
            return;
        }
        this.updateJobSink(size, expiration);
    }

    @VisibleForTesting
    void updateJobSink(int size, TimeValue expiration) {
        FilteredLogSink<JobContextLog> sink = this.createSink(size, expiration, JobContextLog::ramBytesUsed, "jobs_log");
        FilteredLogSink<JobContextLog> newSink = sink.equals(NoopLogSink.instance()) ? sink : new FilteredLogSink<JobContextLog>(this.memoryFilter, this.persistFilter, jobContextLog -> new ParameterizedMessage("Statement execution: stmt=\"{}\" duration={}, user={} error=\"{}\"", new Object[]{jobContextLog.statement(), jobContextLog.ended() - jobContextLog.started(), jobContextLog.username(), jobContextLog.errorMessage()}), sink);
        this.jobsLogs.updateJobsLog((LogSink<JobContextLog>)newSink);
    }

    static long clearInterval(TimeValue expiration) {
        return Long.min(Long.max(1000L, expiration.millis() / 10L), 86400000L);
    }

    private <E extends ContextLog> LogSink<E> createSink(int size, TimeValue expiration, ToLongFunction<E> getElementSize, String breaker) {
        Runnable onClose;
        BlockingEvictingQueue q;
        long expirationMillis = expiration.millis();
        if (size == 0 && expirationMillis == 0L) {
            return NoopLogSink.instance();
        }
        if (expirationMillis > 0L) {
            q = new ConcurrentLinkedDeque();
            long delay = 0L;
            long intervalInMs = JobsLogService.clearInterval(expiration);
            ScheduledFuture<?> scheduledFuture = TimeBasedQEviction.scheduleTruncate(delay, intervalInMs, (Queue<? extends ContextLog>)q, this.scheduler, expiration);
            onClose = () -> scheduledFuture.cancel(false);
        } else {
            q = new BlockingEvictingQueue(size);
            onClose = () -> {};
        }
        RamAccountingQueue accountingQueue = new RamAccountingQueue(q, this.breakerService.getBreaker(breaker), getElementSize);
        return new QueueSink<E>(accountingQueue, () -> {
            accountingQueue.release();
            onClose.run();
        });
    }

    private void setOperationsLogSink(int size, TimeValue expiration) {
        this.operationsLogSize = size;
        this.operationsLogExpiration = expiration;
        if (!this.isEnabled) {
            return;
        }
        this.updateOperationSink(size, expiration);
    }

    @VisibleForTesting
    void updateOperationSink(int size, TimeValue expiration) {
        LogSink<OperationContextLog> newSink = this.createSink(size, expiration, OperationContextLog::ramBytesUsed, "operations_log");
        this.jobsLogs.updateOperationsLog(newSink);
    }

    private void setStatsEnabled(boolean enableStats) {
        if (enableStats) {
            this.isEnabled = true;
            this.setOperationsLogSink(this.operationsLogSize, this.operationsLogExpiration);
            this.setJobsLogSink(this.jobsLogSize, this.jobsLogExpiration);
        } else {
            this.isEnabled = false;
            this.updateOperationSink(0, TimeValue.timeValueSeconds((long)0L));
            this.updateJobSink(0, TimeValue.timeValueSeconds((long)0L));
            this.jobsLogs.resetMetrics();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.jobsLogs.close();
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private JobsLogs statsTables() {
        return this.jobsLogs;
    }

    public JobsLogs get() {
        return this.statsTables();
    }

    @VisibleForTesting
    public int jobsLogSize() {
        return this.jobsLogSize;
    }

    private static class FilterValidator
    implements Setting.Validator<String> {
        Consumer<String> validate = s -> {};

        private FilterValidator() {
        }

        @Override
        public void validate(String value) {
            this.validate.accept(value);
        }
    }
}

