/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.execution.engine.collect.stats.NodeStatsRequest;
import io.crate.execution.engine.collect.stats.NodeStatsResponse;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import io.crate.expression.reference.sys.node.NodeStatsContext;
import io.crate.expression.reference.sys.node.NodeStatsContextFieldResolver;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportNodeStatsAction
extends TransportAction<NodeStatsRequest, NodeStatsResponse> {
    private final NodeStatsContextFieldResolver nodeContextFieldsResolver;
    private final Transports transports;

    @Inject
    public TransportNodeStatsAction(TransportService transportService, NodeStatsContextFieldResolver nodeContextFieldsResolver, Transports transports) {
        super("internal:crate:sql/sys/nodes");
        this.nodeContextFieldsResolver = nodeContextFieldsResolver;
        this.transports = transports;
        transportService.registerRequestHandler("internal:crate:sql/sys/nodes", "management", NodeStatsRequest.StatsRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    @Override
    public void doExecute(NodeStatsRequest request, ActionListener<NodeStatsResponse> listener) {
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(request.timeout()).build();
        this.transports.sendRequest("internal:crate:sql/sys/nodes", request.nodeId(), (NodeStatsRequest.StatsRequest)request.innerRequest(), listener, new ActionListenerResponseHandler<NodeStatsResponse>(listener, NodeStatsResponse::new), options);
    }

    public CompletableFuture<NodeStatsResponse> nodeOperation(NodeStatsRequest.StatsRequest request) {
        try {
            NodeStatsContext context = this.nodeContextFieldsResolver.forTopColumnIdents(request.columnIdents());
            return CompletableFuture.completedFuture(new NodeStatsResponse(context));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

