/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.breaker.CellsSizeEstimator;
import io.crate.data.Bucket;
import io.crate.data.CloseableIterator;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.fetch.FetchId;
import io.crate.execution.engine.fetch.FetchRows;
import io.crate.execution.engine.fetch.ReaderBucket;
import io.crate.planner.node.fetch.FetchSource;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import org.apache.lucene.util.Accountable;

public class ReaderBuckets
implements Accountable {
    private final IntObjectHashMap<ReaderBucket> readerBuckets = new IntObjectHashMap();
    private final ArrayList<Object[]> rows = new ArrayList();
    private final FetchRows fetchRows;
    private final CellsSizeEstimator estimateRow;
    private final RamAccounting ramAccounting;
    private final IntFunction<FetchSource> getFetchSource;
    private long usedMemoryEstimateInBytes;

    public ReaderBuckets(FetchRows fetchRows, IntFunction<FetchSource> getFetchSource, CellsSizeEstimator estimateRow, RamAccounting ramAccounting) {
        this.fetchRows = fetchRows;
        this.getFetchSource = getFetchSource;
        this.estimateRow = estimateRow;
        this.ramAccounting = ramAccounting;
    }

    public void add(Row row) {
        Object[] cells = row.materialize();
        long size = this.estimateRow.estimateSize(cells);
        this.ramAccounting.addBytes(size);
        this.usedMemoryEstimateInBytes += size;
        this.rows.add(cells);
        for (int i : this.fetchRows.fetchIdPositions()) {
            Object fetchId = cells[i];
            if (fetchId == null) continue;
            this.require((Long)fetchId);
        }
    }

    private void require(long fetchId) {
        int readerId = FetchId.decodeReaderId(fetchId);
        int docId = FetchId.decodeDocId(fetchId);
        ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(readerId);
        if (readerBucket == null) {
            readerBucket = new ReaderBucket(this.ramAccounting, this.getFetchSource.apply(readerId));
            this.readerBuckets.put(readerId, (Object)readerBucket);
        }
        readerBucket.require(docId);
    }

    public CloseableIterator<Row> getOutputRows(List<IntObjectMap<? extends Bucket>> resultsByReader) {
        for (IntObjectMap<? extends Bucket> result : resultsByReader) {
            if (result == null) continue;
            for (IntObjectCursor cursor : result) {
                ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(cursor.key);
                assert (readerBucket != null) : "If we get a result for a reader, there must be a readerBucket for it";
                this.usedMemoryEstimateInBytes += readerBucket.fetched((Bucket)cursor.value);
                cursor.value = null;
            }
        }
        return new CloseableIterator<Row>(){
            int idx = 0;

            public boolean hasNext() {
                return this.idx < ReaderBuckets.this.rows.size();
            }

            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Iterator is exhausted");
                }
                Object[] row = ReaderBuckets.this.rows.get(this.idx);
                ++this.idx;
                return ReaderBuckets.this.fetchRows.updatedOutputRow(row, arg_0 -> ReaderBuckets.this.readerBuckets.get(arg_0));
            }

            public void close() throws RuntimeException {
                ReaderBuckets.this.rows.clear();
                ReaderBuckets.this.readerBuckets.release();
                ReaderBuckets.this.ramAccounting.addBytes(-ReaderBuckets.this.usedMemoryEstimateInBytes);
                ReaderBuckets.this.usedMemoryEstimateInBytes = 0L;
            }
        };
    }

    public IntObjectHashMap<IntArrayList> generateToFetch(IntSet readerIds) {
        IntObjectHashMap toFetch = new IntObjectHashMap(readerIds.size());
        for (IntCursor readerIdCursor : readerIds) {
            ReaderBucket readerBucket = (ReaderBucket)this.readerBuckets.get(readerIdCursor.value);
            if (readerBucket == null || readerBucket.isEmpty()) continue;
            toFetch.put(readerIdCursor.value, (Object)readerBucket.sortedDocs());
        }
        return toFetch;
    }

    public long ramBytesUsed() {
        return this.usedMemoryEstimateInBytes;
    }
}

