/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;

public class ReaderContext {
    private final LeafReaderContext leafReaderContext;
    private final DocumentFieldsReader storedFieldsReader;

    public ReaderContext(LeafReaderContext leafReaderContext, DocumentFieldsReader storedFieldsReader) {
        this.leafReaderContext = leafReaderContext;
        this.storedFieldsReader = storedFieldsReader;
    }

    public ReaderContext(LeafReaderContext leafReaderContext) throws IOException {
        LeafReader reader = leafReaderContext.reader();
        StoredFields storedFields = reader.storedFields();
        this.leafReaderContext = leafReaderContext;
        this.storedFieldsReader = (arg_0, arg_1) -> ((StoredFields)storedFields).document(arg_0, arg_1);
    }

    public void visitDocument(int docId, StoredFieldVisitor visitor) throws IOException {
        this.storedFieldsReader.document(docId, visitor);
    }

    public LeafReader reader() {
        return this.leafReaderContext.reader();
    }

    public int docBase() {
        return this.leafReaderContext.docBase;
    }

    static interface DocumentFieldsReader {
        public void document(int var1, StoredFieldVisitor var2) throws IOException;
    }
}

