/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.ItemFactory;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.engine.indexing.UpsertResults;
import io.crate.execution.jobs.NodeLimits;
import io.crate.expression.InputRow;
import io.crate.expression.symbol.Assignments;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class ColumnIndexWriterProjector
implements Projector {
    private final ShardingUpsertExecutor shardingUpsertExecutor;

    public ColumnIndexWriterProjector(ClusterService clusterService, BiConsumer<String, IndexItem> constraintsChecker, NodeLimits nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, TransactionContext txnCtx, NodeContext nodeCtx, Settings settings, int targetTableNumShards, int targetTableNumReplicas, Supplier<String> indexNameResolver, ElasticsearchClient elasticsearchClient, List<ColumnIdent> primaryKeyIdents, List<? extends Symbol> primaryKeySymbols, @Nullable Symbol routingSymbol, ColumnIdent clusteredByColumn, List<Reference> columnReferences, List<Input<?>> insertInputs, List<? extends CollectExpression<Row, ?>> collectExpressions, boolean ignoreDuplicateKeys, @Nullable Map<Reference, Symbol> onConflictAssignmentsByRef, int bulkActions, boolean autoCreateIndices, List<Symbol> returnValues, UUID jobId, long fullDocSizeEstimate) {
        Symbol[] onConflictAssignments;
        String[] onConflictColumns;
        RowShardResolver rowShardResolver = new RowShardResolver(txnCtx, nodeCtx, primaryKeyIdents, primaryKeySymbols, clusteredByColumn, routingSymbol);
        assert (columnReferences.size() == insertInputs.size()) : "number of insert inputs must be equal to the number of columns";
        if (onConflictAssignmentsByRef == null) {
            onConflictColumns = null;
            onConflictAssignments = null;
        } else {
            Assignments convert = Assignments.convert(onConflictAssignmentsByRef, nodeCtx);
            onConflictColumns = convert.targetNames();
            onConflictAssignments = convert.sources();
        }
        Reference[] insertColumns = columnReferences.toArray(new Reference[columnReferences.size()]);
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(settings), ignoreDuplicateKeys ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, onConflictColumns, insertColumns, returnValues.isEmpty() ? null : returnValues.toArray(new Symbol[0]), jobId);
        InputRow insertValues = new InputRow(insertInputs);
        ItemFactory<ShardUpsertRequest.Item> itemFactory = (id, pkValues, autoGeneratedTimestamp) -> ShardUpsertRequest.Item.forInsert(id, pkValues, autoGeneratedTimestamp, insertColumns, insertValues.materialize(), onConflictAssignments, fullDocSizeEstimate);
        UpsertResultContext upsertResultContext = returnValues.isEmpty() ? UpsertResultContext.forRowCount() : UpsertResultContext.forResultRows();
        this.shardingUpsertExecutor = new ShardingUpsertExecutor(clusterService, constraintsChecker, nodeJobsCounter, queryCircuitBreaker, ramAccounting, scheduler, executor, bulkActions, jobId, rowShardResolver, itemFactory, builder::newRequest, collectExpressions, indexNameResolver, autoCreateIndices, elasticsearchClient, targetTableNumShards, targetTableNumReplicas, upsertResultContext, upsertResults -> false, UpsertResults::resultsToFailure);
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, (Function)this.shardingUpsertExecutor, (boolean)batchIterator.hasLazyResultSet());
    }

    public boolean providesIndependentScroll() {
        return false;
    }
}

