/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.data.BatchIterator;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.memory.MemoryManager;
import io.crate.metadata.TransactionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.VisibleForTesting;

public final class Projectors {
    @VisibleForTesting
    final ArrayList<Projector> projectors;
    private final boolean independentScroll;

    public Projectors(Collection<? extends Projection> projections, UUID jobId, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, ProjectorFactory projectorFactory) {
        boolean independentScroll = false;
        this.projectors = new ArrayList(projections.size());
        for (Projection projection : projections) {
            if (projection.requiredGranularity().ordinal() > projectorFactory.supportedGranularity().ordinal()) continue;
            Projector projector = projectorFactory.create(projection, txnCtx, ramAccounting, memoryManager, jobId);
            this.projectors.add(projector);
            independentScroll = independentScroll || projector.providesIndependentScroll();
        }
        this.independentScroll = independentScroll;
    }

    public static BatchIterator<Row> wrap(Collection<? extends Projection> projections, UUID jobId, TransactionContext txnCtx, RamAccounting ramAccounting, MemoryManager memoryManager, ProjectorFactory projectorFactory, BatchIterator<Row> source) {
        BatchIterator result = source;
        for (Projection projection : projections) {
            if (projection.requiredGranularity().ordinal() > projectorFactory.supportedGranularity().ordinal()) continue;
            result = (BatchIterator)projectorFactory.create(projection, txnCtx, ramAccounting, memoryManager, jobId).apply((Object)result);
        }
        return result;
    }

    public BatchIterator<Row> wrap(BatchIterator<Row> source) {
        BatchIterator result = source;
        for (Projector projector : this.projectors) {
            result = (BatchIterator)projector.apply(result);
        }
        return result;
    }

    public boolean providesIndependentScroll() {
        return this.independentScroll;
    }
}

