/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.Streamer;
import io.crate.breaker.ConcurrentRamAccounting;
import io.crate.breaker.TypedCellsAccounting;
import io.crate.breaker.TypedRowAccounting;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.IncrementalPageBucketReceiver;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.dsl.phases.HashJoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.execution.dsl.projection.AggregationProjection;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.Projections;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.engine.aggregation.AggregateCollector;
import io.crate.execution.engine.aggregation.AggregationPipe;
import io.crate.execution.engine.aggregation.GroupingProjector;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.MapSideDataCollectOperation;
import io.crate.execution.engine.collect.PKLookupOperation;
import io.crate.execution.engine.collect.count.CountOperation;
import io.crate.execution.engine.collect.sources.ShardCollectSource;
import io.crate.execution.engine.collect.sources.SystemCollectSource;
import io.crate.execution.engine.distribution.DistributingConsumer;
import io.crate.execution.engine.distribution.DistributingConsumerFactory;
import io.crate.execution.engine.distribution.SingleBucketBuilder;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import io.crate.execution.engine.fetch.FetchTask;
import io.crate.execution.engine.join.HashJoinOperation;
import io.crate.execution.engine.join.NestedLoopOperation;
import io.crate.execution.engine.pipeline.ProjectingRowConsumer;
import io.crate.execution.engine.pipeline.ProjectionToProjectorVisitor;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.jobs.CountTask;
import io.crate.execution.jobs.CumulativePageBucketReceiver;
import io.crate.execution.jobs.DistResultRXTask;
import io.crate.execution.jobs.JoinTask;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.jobs.PKLookupTask;
import io.crate.execution.jobs.PageBucketReceiver;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.Task;
import io.crate.expression.InputFactory;
import io.crate.expression.RowFilter;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.memory.MemoryManager;
import io.crate.memory.MemoryManagerFactory;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.SessionSettings;
import io.crate.planner.distribution.DistributionType;
import io.crate.planner.operators.PKAndVersion;
import io.crate.sql.tree.JoinType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

@Singleton
public class JobSetup {
    private static final Logger LOGGER = LogManager.getLogger(JobSetup.class);
    private final MapSideDataCollectOperation collectOperation;
    private final ClusterService clusterService;
    private final CircuitBreakerService circuitBreakerService;
    private final CountOperation countOperation;
    private final MemoryManagerFactory memoryManagerFactory;
    private final DistributingConsumerFactory distributingConsumerFactory;
    private final InnerPreparer innerPreparer;
    private final InputFactory inputFactory;
    private final ProjectorFactory projectorFactory;
    private final PKLookupOperation pkLookupOperation;
    private final Executor searchTp;
    private final String nodeName;
    private final Schemas schemas;

    @Inject
    public JobSetup(Settings settings, MapSideDataCollectOperation collectOperation, ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreakerService circuitBreakerService, CountOperation countOperation, ThreadPool threadPool, DistributingConsumerFactory distributingConsumerFactory, Node node, IndicesService indicesService, NodeContext nodeCtx, SystemCollectSource systemCollectSource, ShardCollectSource shardCollectSource, MemoryManagerFactory memoryManagerFactory) {
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.schemas = nodeCtx.schemas();
        this.collectOperation = collectOperation;
        this.clusterService = clusterService;
        this.circuitBreakerService = circuitBreakerService;
        this.countOperation = countOperation;
        this.memoryManagerFactory = memoryManagerFactory;
        this.pkLookupOperation = new PKLookupOperation(indicesService, shardCollectSource);
        this.distributingConsumerFactory = distributingConsumerFactory;
        this.innerPreparer = new InnerPreparer();
        this.inputFactory = new InputFactory(nodeCtx);
        this.searchTp = threadPool.executor("search");
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(nodeCtx);
        this.projectorFactory = new ProjectionToProjectorVisitor(clusterService, nodeJobsCounter, circuitBreakerService, nodeCtx, threadPool, settings, node.client(), this.inputFactory, normalizer, systemCollectSource::getRowUpdater, systemCollectSource::tableDefinition);
    }

    public List<CompletableFuture<StreamBucket>> prepareOnRemote(SessionSettings sessionInfo, Collection<? extends NodeOperation> nodeOperations, RootTask.Builder contextBuilder, SharedShardContexts sharedShardContexts) {
        Context context = new Context(this.clusterService.localNode().getId(), sessionInfo, contextBuilder, LOGGER, this.distributingConsumerFactory, nodeOperations, sharedShardContexts);
        this.registerContextPhases(nodeOperations, context);
        LOGGER.trace("prepareOnRemote: job={} nodeOperations={} targetSourceMap={}", (Object)contextBuilder.jobId(), nodeOperations, context.opCtx.targetToSourceMap);
        for (IntCursor intCursor : context.opCtx.findLeafs()) {
            this.prepareSourceOperations(intCursor.value, context);
        }
        assert (context.opCtx.allNodeOperationContextsBuilt()) : "some nodeOperations haven't been processed";
        return context.directResponseFutures;
    }

    public List<CompletableFuture<StreamBucket>> prepareOnHandler(SessionSettings sessionInfo, Collection<? extends NodeOperation> nodeOperations, RootTask.Builder taskBuilder, List<JobLauncher.HandlerPhase> handlerPhases, SharedShardContexts sharedShardContexts) {
        Context context = new Context(this.clusterService.localNode().getId(), sessionInfo, taskBuilder, LOGGER, this.distributingConsumerFactory, nodeOperations, sharedShardContexts);
        for (JobLauncher.HandlerPhase handlerPhase : handlerPhases) {
            context.registerLeaf(handlerPhase.phase(), handlerPhase.consumer());
        }
        this.registerContextPhases(nodeOperations, context);
        LOGGER.trace("prepareOnHandler: jobId={} nodeOperations={} handlerPhases={} targetSourceMap={}", (Object)taskBuilder.jobId(), nodeOperations, handlerPhases, context.opCtx.targetToSourceMap);
        IntHashSet leafs = new IntHashSet();
        for (JobLauncher.HandlerPhase handlerPhase : handlerPhases) {
            ExecutionPhase phase = handlerPhase.phase();
            this.createContexts(phase, context);
            leafs.add(phase.phaseId());
        }
        leafs.addAll(context.opCtx.findLeafs());
        for (IntCursor cursor : leafs) {
            this.prepareSourceOperations(cursor.value, context);
        }
        assert (context.opCtx.allNodeOperationContextsBuilt()) : "some nodeOperations haven't been processed";
        return context.directResponseFutures;
    }

    private void createContexts(ExecutionPhase phase, Context context) {
        try {
            phase.accept(this.innerPreparer, context);
        }
        catch (Throwable t) {
            IllegalArgumentException e = new IllegalArgumentException(String.format(Locale.ENGLISH, "Couldn't create executionContexts from%nNodeOperations: %s%nLeafs: %s%ntarget-sources: %s%noriginal-error: %s", context.opCtx.nodeOperationByPhaseId, context.leafs, context.opCtx.targetToSourceMap, t.getClass().getSimpleName() + ": " + t.getMessage()), t);
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    private void registerContextPhases(Iterable<? extends NodeOperation> nodeOperations, Context context) {
        for (NodeOperation nodeOperation : nodeOperations) {
            if (nodeOperation.downstreamExecutionPhaseId() == Integer.MAX_VALUE) {
                LOGGER.trace("Building context for nodeOp without downstream: {}", (Object)nodeOperation);
                this.createContexts(nodeOperation.executionPhase(), context);
                context.opCtx.builtNodeOperations.set(nodeOperation.executionPhase().phaseId());
            }
            if (!ExecutionPhases.hasDirectResponseDownstream(nodeOperation.downstreamNodes())) continue;
            ExecutionPhase executionPhase = nodeOperation.executionPhase();
            CircuitBreaker breaker = this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            BlockBasedRamAccounting ramAccounting = new BlockBasedRamAccounting(b -> breaker.addEstimateBytesAndMaybeBreak(b, executionPhase.label()), ramAccountingBlockSizeInBytes);
            Streamer<?>[] streamers = executionPhase.getStreamers();
            SingleBucketBuilder bucketBuilder = new SingleBucketBuilder(streamers, (RamAccounting)ramAccounting);
            context.directResponseFutures.add((CompletableFuture<StreamBucket>)bucketBuilder.completionFuture().whenComplete((res, err) -> ramAccounting.close()));
            context.registerBatchConsumer(nodeOperation.downstreamExecutionPhaseId(), bucketBuilder);
        }
    }

    private void prepareSourceOperations(int startPhaseId, Context context) {
        IntContainer sourcePhaseIds = (IntContainer)context.opCtx.targetToSourceMap.get(startPhaseId);
        if (sourcePhaseIds == null) {
            return;
        }
        for (IntCursor sourcePhaseId : sourcePhaseIds) {
            NodeOperation nodeOperation = (NodeOperation)context.opCtx.nodeOperationByPhaseId.get(sourcePhaseId.value);
            this.createContexts(nodeOperation.executionPhase(), context);
            context.opCtx.builtNodeOperations.set(nodeOperation.executionPhase().phaseId());
        }
        for (IntCursor sourcePhaseId : sourcePhaseIds) {
            this.prepareSourceOperations(sourcePhaseId.value, context);
        }
    }

    private CircuitBreaker breaker() {
        return this.circuitBreakerService.getBreaker("query");
    }

    private static long toKey(int phaseId, byte inputId) {
        return (long)phaseId << 32 | (long)inputId & 0xFFFFFFFFL;
    }

    private class InnerPreparer
    extends ExecutionPhaseVisitor<Context, Void> {
        private InnerPreparer() {
        }

        @Override
        public Void visitCountPhase(CountPhase phase, Context context) {
            String localNodeId;
            Map<String, Map<String, IntIndexedContainer>> locations = phase.routing().locations();
            Map<String, IntIndexedContainer> indexShardMap = locations.get(localNodeId = JobSetup.this.clusterService.localNode().getId());
            if (indexShardMap == null) {
                throw new IllegalArgumentException("The routing of the countPhase doesn't contain the current nodeId");
            }
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            RowConsumer consumer = context.getRowConsumer(phase, Integer.MAX_VALUE, (RamAccounting)new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes));
            consumer.completionFuture().whenComplete((result, error) -> ramAccounting.close());
            context.registerSubContext(new CountTask(phase, context.transactionContext, JobSetup.this.countOperation, consumer, indexShardMap));
            return null;
        }

        @Override
        public Void visitPKLookup(PKLookupPhase pkLookupPhase, Context context) {
            Collection<? extends Projection> shardProjections = Projections.shardProjections(pkLookupPhase.projections());
            Collection<? extends Projection> nodeProjections = Projections.nodeProjections(pkLookupPhase.projections());
            Map<ShardId, SequencedSet<PKAndVersion>> idsByShardId = pkLookupPhase.getIdsByShardId(JobSetup.this.clusterService.localNode().getId());
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytesPerShard((long)breaker.getLimit(), (int)idsByShardId.size());
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(pkLookupPhase.label(), breaker, context.operationMemoryLimitInBytes());
            BlockBasedRamAccounting consumerRamAccounting = new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes);
            MemoryManager consumerMemoryManager = JobSetup.this.memoryManagerFactory.getMemoryManager(ramAccounting);
            RowConsumer lastConsumer = context.getRowConsumer(pkLookupPhase, Integer.MAX_VALUE, (RamAccounting)consumerRamAccounting);
            lastConsumer.completionFuture().whenComplete((result, error) -> {
                consumerMemoryManager.close();
                ramAccounting.close();
            });
            RowConsumer nodeRowConsumer = ProjectingRowConsumer.create(lastConsumer, nodeProjections, pkLookupPhase.jobId(), context.txnCtx(), (RamAccounting)consumerRamAccounting, consumerMemoryManager, JobSetup.this.projectorFactory);
            context.registerSubContext(new PKLookupTask(pkLookupPhase.jobId(), pkLookupPhase.phaseId(), pkLookupPhase.name(), ramAccounting, JobSetup.this.memoryManagerFactory, ramAccountingBlockSizeInBytes, context.transactionContext, JobSetup.this.schemas, JobSetup.this.inputFactory, JobSetup.this.pkLookupOperation, pkLookupPhase.partitionedByColumns(), pkLookupPhase.toCollect(), idsByShardId, shardProjections, nodeRowConsumer));
            return null;
        }

        @Override
        public Void visitMergePhase(MergePhase phase, Context context) {
            context.taskBuilder.addParticipants(phase.upstreamNodes());
            boolean upstreamOnSameNode = context.opCtx.upstreamsAreOnSameNode(phase.phaseId());
            int pageSize = Paging.getWeightedPageSize((Integer)Paging.PAGE_SIZE, (double)(1.0 / (double)phase.nodeIds().size()));
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            BlockBasedRamAccounting ramAccountingForMerge = new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes);
            RowConsumer finalRowConsumer = context.getRowConsumer(phase, pageSize, (RamAccounting)ramAccountingForMerge);
            MemoryManager memoryManager = JobSetup.this.memoryManagerFactory.getMemoryManager(ramAccounting);
            finalRowConsumer.completionFuture().whenComplete((object, throwable) -> {
                memoryManager.close();
                ramAccounting.close();
            });
            if (upstreamOnSameNode && phase.numInputs() == 1) {
                RowConsumer projectingRowConsumer = ProjectingRowConsumer.create(finalRowConsumer, phase.projections(), phase.jobId(), context.txnCtx(), (RamAccounting)ramAccountingForMerge, memoryManager, JobSetup.this.projectorFactory);
                context.registerBatchConsumer(phase.phaseId(), projectingRowConsumer);
                return null;
            }
            AggregateCollector collector = null;
            List<Projection> projections = phase.projections();
            if (projections.size() > 0) {
                Projection firstProjection = projections.get(0);
                if (firstProjection instanceof GroupProjection) {
                    GroupProjection groupProjection = (GroupProjection)firstProjection;
                    GroupingProjector groupingProjector = (GroupingProjector)JobSetup.this.projectorFactory.create(groupProjection, context.txnCtx(), (RamAccounting)ramAccountingForMerge, memoryManager, phase.jobId());
                    collector = groupingProjector.getCollector();
                    projections = projections.subList(1, projections.size());
                } else if (firstProjection instanceof AggregationProjection) {
                    AggregationProjection aggregationProjection = (AggregationProjection)firstProjection;
                    AggregationPipe aggregationPipe = (AggregationPipe)JobSetup.this.projectorFactory.create(aggregationProjection, context.txnCtx(), (RamAccounting)ramAccountingForMerge, memoryManager, phase.jobId());
                    collector = aggregationPipe.getCollector();
                    projections = projections.subList(1, projections.size());
                }
            }
            RowConsumer projectingRowConsumer = ProjectingRowConsumer.create(finalRowConsumer, projections, phase.jobId(), context.txnCtx(), (RamAccounting)ramAccountingForMerge, memoryManager, JobSetup.this.projectorFactory);
            PageBucketReceiver pageBucketReceiver = collector == null ? new CumulativePageBucketReceiver(JobSetup.this.nodeName, phase.phaseId(), JobSetup.this.searchTp, DataTypes.getStreamers(phase.inputTypes()), projectingRowConsumer, PagingIterator.create(phase.numUpstreams(), phase.inputTypes(), projectingRowConsumer.requiresScroll(), phase.orderByPositions(), () -> new TypedRowAccounting(phase.inputTypes(), (RamAccounting)new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes))), phase.numUpstreams()) : new IncrementalPageBucketReceiver(collector, projectingRowConsumer, JobSetup.this.searchTp, DataTypes.getStreamers(phase.inputTypes()), phase.numUpstreams());
            context.registerSubContext(new DistResultRXTask(phase.phaseId(), phase.name(), pageBucketReceiver, ramAccounting, phase.numUpstreams()));
            return null;
        }

        @Override
        public Void visitRoutedCollectPhase(RoutedCollectPhase phase, Context context) {
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytesPerShard((long)breaker.getLimit(), (int)phase.routing().numShards(JobSetup.this.clusterService.localNode().getId()));
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            RowConsumer consumer = context.getRowConsumer(phase, Objects.requireNonNullElse(phase.nodePageSizeHint(), Paging.PAGE_SIZE), (RamAccounting)new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes));
            consumer.completionFuture().whenComplete((result, error) -> ramAccounting.close());
            context.registerSubContext(new CollectTask(phase, context.txnCtx(), JobSetup.this.collectOperation, ramAccounting, JobSetup.this.memoryManagerFactory, consumer, context.sharedShardContexts, JobSetup.this.clusterService.state().nodes().getMinNodeVersion(), ramAccountingBlockSizeInBytes));
            return null;
        }

        @Override
        public Void visitCollectPhase(CollectPhase phase, Context context) {
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            RowConsumer consumer = context.getRowConsumer(phase, Paging.PAGE_SIZE, (RamAccounting)new BlockBasedRamAccounting(arg_0 -> ((RamAccounting)ramAccounting).addBytes(arg_0), ramAccountingBlockSizeInBytes));
            consumer.completionFuture().whenComplete((result, error) -> ramAccounting.close());
            context.registerSubContext(new CollectTask(phase, context.txnCtx(), JobSetup.this.collectOperation, ramAccounting, JobSetup.this.memoryManagerFactory, consumer, context.sharedShardContexts, JobSetup.this.clusterService.state().nodes().getMinNodeVersion(), ramAccountingBlockSizeInBytes));
            return null;
        }

        @Override
        public Void visitFetchPhase(FetchPhase phase, Context context) {
            ArrayList routings = new ArrayList();
            context.opCtx.nodeOperationByPhaseId.values().forEach(value -> {
                ExecutionPhase executionPhase = value.executionPhase();
                if (executionPhase instanceof RoutedCollectPhase) {
                    routings.add(((RoutedCollectPhase)executionPhase).routing());
                }
            });
            context.leafs.forEach(executionPhase -> {
                if (executionPhase instanceof RoutedCollectPhase) {
                    routings.add(((RoutedCollectPhase)executionPhase).routing());
                }
            });
            assert (!routings.isEmpty()) : "Routings must be present. It doesn't make sense to have a FetchPhase on a node without at least one CollectPhase on the same node";
            String localNodeId = JobSetup.this.clusterService.localNode().getId();
            context.registerSubContext(new FetchTask(context.jobId(), phase, context.operationMemoryLimitInBytes(), localNodeId, context.sharedShardContexts, JobSetup.this.clusterService.state().metadata(), relationName -> (DocTableInfo)JobSetup.this.schemas.getTableInfo((RelationName)relationName), routings));
            return null;
        }

        @Override
        public Void visitNestedLoopPhase(NestedLoopPhase phase, Context context) {
            DistResultRXTask right;
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            ConcurrentRamAccounting concurrentRamAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            BlockBasedRamAccounting ramAccountingOfOperation = new BlockBasedRamAccounting(concurrentRamAccounting::addBytes, ramAccountingBlockSizeInBytes);
            RowConsumer lastConsumer = context.getRowConsumer(phase, Paging.PAGE_SIZE, (RamAccounting)ramAccountingOfOperation);
            MemoryManager memoryManager = JobSetup.this.memoryManagerFactory.getMemoryManager(concurrentRamAccounting);
            lastConsumer.completionFuture().whenComplete((result, error) -> {
                memoryManager.close();
                concurrentRamAccounting.close();
            });
            RowConsumer firstConsumer = ProjectingRowConsumer.create(lastConsumer, phase.projections(), phase.jobId(), context.txnCtx(), (RamAccounting)ramAccountingOfOperation, memoryManager, JobSetup.this.projectorFactory);
            Predicate<Row> joinCondition = RowFilter.create(context.transactionContext, JobSetup.this.inputFactory, phase.joinCondition());
            NestedLoopOperation joinOperation = new NestedLoopOperation(phase.numLeftOutputs(), phase.numRightOutputs(), firstConsumer, joinCondition, phase.joinType(), JobSetup.this.breaker(), (RamAccounting)ramAccountingOfOperation, phase.leftSideColumnTypes, phase.estimatedRowsSizeLeft, phase.estimatedNumberOfRowsLeft, phase.blockNestedLoop);
            DistResultRXTask left = this.pageDownstreamContextForNestedLoop(phase.phaseId(), context, (byte)0, phase.leftMergePhase(), joinOperation.leftConsumer(), (RamAccounting)new BlockBasedRamAccounting(concurrentRamAccounting::addBytes, ramAccountingBlockSizeInBytes), memoryManager);
            if (left != null) {
                context.registerSubContext(left);
            }
            if ((right = this.pageDownstreamContextForNestedLoop(phase.phaseId(), context, (byte)1, phase.rightMergePhase(), joinOperation.rightConsumer(), (RamAccounting)new BlockBasedRamAccounting(concurrentRamAccounting::addBytes, ramAccountingBlockSizeInBytes), memoryManager)) != null) {
                context.registerSubContext(right);
            }
            context.registerSubContext(new JoinTask(phase, joinOperation, left != null ? left.getBucketReceiver((byte)0) : null, right != null ? right.getBucketReceiver((byte)0) : null));
            return null;
        }

        @Override
        public Void visitHashJoinPhase(HashJoinPhase phase, Context context) {
            DistResultRXTask right;
            CircuitBreaker breaker = JobSetup.this.breaker();
            int ramAccountingBlockSizeInBytes = BlockBasedRamAccounting.blockSizeInBytes((long)breaker.getLimit());
            ConcurrentRamAccounting ramAccounting = ConcurrentRamAccounting.forCircuitBreaker(phase.label(), breaker, context.operationMemoryLimitInBytes());
            BlockBasedRamAccounting ramAccountingOfOperation = new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes);
            RowConsumer lastConsumer = context.getRowConsumer(phase, Paging.PAGE_SIZE, (RamAccounting)ramAccountingOfOperation);
            MemoryManager memoryManager = JobSetup.this.memoryManagerFactory.getMemoryManager(ramAccounting);
            lastConsumer.completionFuture().whenComplete((result, error) -> {
                memoryManager.close();
                ramAccounting.close();
            });
            RowConsumer firstConsumer = ProjectingRowConsumer.create(lastConsumer, phase.projections(), phase.jobId(), context.txnCtx(), (RamAccounting)ramAccountingOfOperation, memoryManager, JobSetup.this.projectorFactory);
            Predicate<Row> joinCondition = RowFilter.create(context.transactionContext, JobSetup.this.inputFactory, phase.joinCondition());
            HashJoinOperation joinOperation = new HashJoinOperation(phase.numLeftOutputs(), phase.numRightOutputs(), firstConsumer, joinCondition, phase.leftJoinConditionInputs(), phase.rightJoinConditionInputs(), new TypedCellsAccounting(phase.leftOutputTypes(), (RamAccounting)ramAccountingOfOperation, 110), context.transactionContext, JobSetup.this.inputFactory, JobSetup.this.breaker(), phase.estimatedRowSizeForLeft(), phase.joinType() == JoinType.LEFT);
            DistResultRXTask left = this.pageDownstreamContextForNestedLoop(phase.phaseId(), context, (byte)0, phase.leftMergePhase(), joinOperation.leftConsumer(), (RamAccounting)new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes), memoryManager);
            if (left != null) {
                context.registerSubContext(left);
            }
            if ((right = this.pageDownstreamContextForNestedLoop(phase.phaseId(), context, (byte)1, phase.rightMergePhase(), joinOperation.rightConsumer(), (RamAccounting)new BlockBasedRamAccounting(ramAccounting::addBytes, ramAccountingBlockSizeInBytes), memoryManager)) != null) {
                context.registerSubContext(right);
            }
            context.registerSubContext(new JoinTask(phase, joinOperation, left != null ? left.getBucketReceiver((byte)0) : null, right != null ? right.getBucketReceiver((byte)0) : null));
            return null;
        }

        @Nullable
        private DistResultRXTask pageDownstreamContextForNestedLoop(int nlPhaseId, Context ctx, byte inputId, @Nullable MergePhase mergePhase, RowConsumer rowConsumer, RamAccounting ramAccounting, MemoryManager memoryManager) {
            if (mergePhase == null) {
                ctx.consumersByPhaseInputId.put(JobSetup.toKey(nlPhaseId, inputId), (Object)rowConsumer);
                return null;
            }
            ctx.taskBuilder.addParticipants(mergePhase.upstreamNodes());
            if (mergePhase.hasProjections()) {
                rowConsumer = ProjectingRowConsumer.create(rowConsumer, mergePhase.projections(), mergePhase.jobId(), ctx.txnCtx(), ramAccounting, memoryManager, JobSetup.this.projectorFactory);
            }
            CumulativePageBucketReceiver pageBucketReceiver = new CumulativePageBucketReceiver(JobSetup.this.nodeName, mergePhase.phaseId(), JobSetup.this.searchTp, mergePhase.getStreamers(), rowConsumer, PagingIterator.create(mergePhase.numUpstreams(), mergePhase.inputTypes(), rowConsumer.requiresScroll(), mergePhase.orderByPositions(), () -> new TypedRowAccounting(mergePhase.inputTypes(), ramAccounting)), mergePhase.numUpstreams());
            return new DistResultRXTask(mergePhase.phaseId(), mergePhase.name(), pageBucketReceiver, ramAccounting, mergePhase.numUpstreams());
        }
    }

    private static class Context {
        private final DistributingConsumerFactory distributingConsumerFactory;
        private final LongObjectMap<RowConsumer> consumersByPhaseInputId = new LongObjectHashMap();
        private final IntObjectMap<RowConsumer> handlerConsumersByPhaseId = new IntObjectHashMap();
        private final SharedShardContexts sharedShardContexts;
        private final List<CompletableFuture<StreamBucket>> directResponseFutures = new ArrayList<CompletableFuture<StreamBucket>>();
        private final NodeOperationCtx opCtx;
        private final RootTask.Builder taskBuilder;
        private final Logger logger;
        private final List<ExecutionPhase> leafs = new ArrayList<ExecutionPhase>();
        private final TransactionContext transactionContext;

        Context(String localNodeId, SessionSettings sessionInfo, RootTask.Builder taskBuilder, Logger logger, DistributingConsumerFactory distributingConsumerFactory, Collection<? extends NodeOperation> nodeOperations, SharedShardContexts sharedShardContexts) {
            this.taskBuilder = taskBuilder;
            this.logger = logger;
            this.opCtx = new NodeOperationCtx(localNodeId, nodeOperations);
            this.distributingConsumerFactory = distributingConsumerFactory;
            this.sharedShardContexts = sharedShardContexts;
            this.transactionContext = TransactionContext.of(sessionInfo);
        }

        public UUID jobId() {
            return this.taskBuilder.jobId();
        }

        public int operationMemoryLimitInBytes() {
            return this.transactionContext.sessionSettings().memoryLimitInBytes();
        }

        RowConsumer getRowConsumer(UpstreamPhase phase, int pageSize, RamAccounting ramAccounting) {
            NodeOperation nodeOperation = (NodeOperation)this.opCtx.nodeOperationByPhaseId.get(phase.phaseId());
            if (nodeOperation == null) {
                return this.handlerPhaseConsumer(phase.phaseId());
            }
            long phaseIdKey = JobSetup.toKey(nodeOperation.downstreamExecutionPhaseId(), nodeOperation.downstreamExecutionPhaseInputId());
            RowConsumer rowConsumer = (RowConsumer)this.consumersByPhaseInputId.get(phaseIdKey);
            if (rowConsumer != null) {
                return rowConsumer;
            }
            this.taskBuilder.addParticipants(nodeOperation.downstreamNodes());
            DistributionType distributionType = phase.distributionInfo().distributionType();
            switch (distributionType) {
                case BROADCAST: 
                case MODULO: {
                    DistributingConsumer consumer = this.distributingConsumerFactory.create(nodeOperation, ramAccounting, phase.distributionInfo(), this.jobId(), pageSize);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("action=getRowReceiver, distributionType={}, phase={}, targetConsumer={}, target={}/{},", (Object)distributionType.toString(), (Object)phase.phaseId(), (Object)consumer, (Object)nodeOperation.downstreamExecutionPhaseId(), (Object)nodeOperation.downstreamExecutionPhaseInputId());
                    }
                    return consumer;
                }
            }
            throw new AssertionError((Object)("unhandled distributionType: " + String.valueOf((Object)distributionType)));
        }

        private RowConsumer handlerPhaseConsumer(int phaseId) {
            RowConsumer consumer = (RowConsumer)this.handlerConsumersByPhaseId.get(phaseId);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Using BatchConsumer {} for phase {}, this is a leaf/handlerPhase", (Object)consumer, (Object)phaseId);
            }
            assert (consumer != null) : "No rowReceiver for handlerPhase " + phaseId;
            return consumer;
        }

        void registerBatchConsumer(int phaseId, RowConsumer consumer) {
            this.consumersByPhaseInputId.put(JobSetup.toKey(phaseId, (byte)0), (Object)consumer);
        }

        void registerSubContext(Task subContext) {
            this.taskBuilder.addTask(subContext);
        }

        void registerLeaf(ExecutionPhase phase, RowConsumer consumer) {
            this.handlerConsumersByPhaseId.put(phase.phaseId(), (Object)consumer);
            this.leafs.add(phase);
        }

        public TransactionContext txnCtx() {
            return this.transactionContext;
        }
    }

    static class NodeOperationCtx {
        private final IntObjectMap<? extends IntContainer> targetToSourceMap;
        private final IntObjectMap<NodeOperation> nodeOperationByPhaseId;
        private final BitSet builtNodeOperations;
        private final String localNodeId;

        public NodeOperationCtx(String localNodeId, Collection<? extends NodeOperation> nodeOperations) {
            this.localNodeId = localNodeId;
            this.targetToSourceMap = NodeOperationCtx.createTargetToSourceMap(nodeOperations);
            this.nodeOperationByPhaseId = NodeOperationCtx.groupNodeOperationsByPhase(nodeOperations);
            this.builtNodeOperations = new BitSet(this.nodeOperationByPhaseId.size());
        }

        private static IntObjectHashMap<NodeOperation> groupNodeOperationsByPhase(Collection<? extends NodeOperation> nodeOperations) {
            IntObjectHashMap map = new IntObjectHashMap(nodeOperations.size());
            for (NodeOperation nodeOperation : nodeOperations) {
                map.put(nodeOperation.executionPhase().phaseId(), (Object)nodeOperation);
            }
            return map;
        }

        static IntObjectHashMap<? extends IntContainer> createTargetToSourceMap(Iterable<? extends NodeOperation> nodeOperations) {
            IntObjectHashMap targetToSource = new IntObjectHashMap();
            for (NodeOperation nodeOperation : nodeOperations) {
                if (nodeOperation.downstreamExecutionPhaseId() == Integer.MAX_VALUE) continue;
                IntArrayList sourceIds = (IntArrayList)targetToSource.get(nodeOperation.downstreamExecutionPhaseId());
                if (sourceIds == null) {
                    sourceIds = new IntArrayList();
                    targetToSource.put(nodeOperation.downstreamExecutionPhaseId(), (Object)sourceIds);
                }
                sourceIds.add(nodeOperation.executionPhase().phaseId());
            }
            return targetToSource;
        }

        private static IntCollection findLeafs(IntObjectMap<? extends IntContainer> targetToSourceMap) {
            IntArrayList leafs = new IntArrayList();
            BitSet sources = new BitSet();
            for (IntObjectCursor sourceIds : targetToSourceMap) {
                for (IntCursor sourceId : (IntContainer)sourceIds.value) {
                    sources.set(sourceId.value);
                }
            }
            for (IntCursor targetPhaseCursor : targetToSourceMap.keys()) {
                int targetPhase = targetPhaseCursor.value;
                if (sources.get(targetPhase)) continue;
                leafs.add(targetPhase);
            }
            return leafs;
        }

        public boolean upstreamsAreOnSameNode(int phaseId) {
            IntContainer sourcePhases = (IntContainer)this.targetToSourceMap.get(phaseId);
            if (sourcePhases == null) {
                return false;
            }
            for (IntCursor sourcePhase : sourcePhases) {
                Collection<String> executionNodes;
                NodeOperation nodeOperation = (NodeOperation)this.nodeOperationByPhaseId.get(sourcePhase.value);
                if (nodeOperation == null) {
                    return false;
                }
                ExecutionPhase executionPhase = nodeOperation.executionPhase();
                if (executionPhase instanceof UpstreamPhase && ((UpstreamPhase)executionPhase).distributionInfo().distributionType() == DistributionType.SAME_NODE || (executionNodes = executionPhase.nodeIds()).size() == 1 && executionNodes.iterator().next().equals(this.localNodeId)) continue;
                return false;
            }
            return true;
        }

        public Iterable<? extends IntCursor> findLeafs() {
            return NodeOperationCtx.findLeafs(this.targetToSourceMap);
        }

        boolean allNodeOperationContextsBuilt() {
            return this.builtNodeOperations.cardinality() == this.nodeOperationByPhaseId.size();
        }
    }
}

