/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.common.concurrent.ConcurrencyLimit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.jetbrains.annotations.Nullable;

@Singleton
public class NodeLimits {
    private volatile ConcurrencyLimit unknownNodelimit;
    private final Map<String, ConcurrencyLimit> limitsPerNode = new ConcurrentHashMap<String, ConcurrencyLimit>();
    private final ClusterSettings clusterSettings;
    public static final Setting<Integer> INITIAL_CONCURRENCY = Setting.intSetting("overload_protection.dml.initial_concurrency", 5, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<Integer> MIN_CONCURRENCY = Setting.intSetting("overload_protection.dml.min_concurrency", 1, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<Integer> MAX_CONCURRENCY = Setting.intSetting("overload_protection.dml.max_concurrency", 100, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<Integer> QUEUE_SIZE = Setting.intSetting("overload_protection.dml.queue_size", 25, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    private static final double SMOOTHING = 0.2;
    private static final int LONG_WINDOW = 600;
    private static final double RTT_TOLERANCE = 1.5;

    @Inject
    public NodeLimits(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
        clusterSettings.addSettingsUpdateConsumer(INITIAL_CONCURRENCY, ignored -> this.wipeLimits());
        clusterSettings.addSettingsUpdateConsumer(MIN_CONCURRENCY, ignored -> this.wipeLimits());
        clusterSettings.addSettingsUpdateConsumer(MAX_CONCURRENCY, ignored -> this.wipeLimits());
        clusterSettings.addSettingsUpdateConsumer(QUEUE_SIZE, ignored -> this.wipeLimits());
    }

    private void wipeLimits() {
        this.unknownNodelimit = null;
        this.limitsPerNode.clear();
    }

    private ConcurrencyLimit newLimit() {
        return new ConcurrencyLimit(this.clusterSettings.get(INITIAL_CONCURRENCY).intValue(), this.clusterSettings.get(MIN_CONCURRENCY).intValue(), this.clusterSettings.get(MAX_CONCURRENCY).intValue(), ignored -> this.clusterSettings.get(QUEUE_SIZE), 0.2, 600, 1.5);
    }

    public ConcurrencyLimit get(@Nullable String nodeId) {
        if (nodeId == null) {
            ConcurrencyLimit unknown = this.unknownNodelimit;
            if (unknown == null) {
                this.unknownNodelimit = unknown = this.newLimit();
            }
            return unknown;
        }
        return this.limitsPerNode.computeIfAbsent(nodeId, ignored -> this.newLimit());
    }

    public void nodeDisconnected(String nodeId) {
        this.limitsPerNode.remove(nodeId);
    }

    public long totalNumInflight() {
        ConcurrencyLimit unknown = this.unknownNodelimit;
        return this.limitsPerNode.values().stream().mapToLong(ConcurrencyLimit::numInflight).sum() + (long)(unknown == null ? 0 : unknown.numInflight());
    }
}

