/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.metadata.IndexName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.jetbrains.annotations.VisibleForTesting;

public class SharedShardContexts {
    private final IndicesService indicesService;
    private final BiFunction<ShardId, Engine.Searcher, Engine.Searcher> wrapSearcher;
    @VisibleForTesting
    final Map<ShardId, SharedShardContext> allocatedShards = new HashMap<ShardId, SharedShardContext>();
    @VisibleForTesting
    int readerId = 0;

    public SharedShardContexts(IndicesService indicesService, BiFunction<ShardId, Engine.Searcher, Engine.Searcher> wrapSearcher) {
        this.indicesService = indicesService;
        this.wrapSearcher = wrapSearcher;
    }

    public CompletableFuture<Void> maybeRefreshReaders(Metadata metadata, Map<String, IntIndexedContainer> shardsByIndex, Map<String, Integer> bases) {
        ArrayList<CompletableFuture<Object>> refreshActions = new ArrayList<CompletableFuture<Object>>();
        for (Map.Entry<String, IntIndexedContainer> entry : shardsByIndex.entrySet()) {
            String indexName = entry.getKey();
            Integer base = bases.get(indexName);
            if (base == null) continue;
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) {
                if (IndexName.isPartitioned(indexName)) continue;
                refreshActions.add(CompletableFuture.failedFuture(new IndexNotFoundException(indexName)));
                continue;
            }
            IndexService indexService = this.indicesService.indexService(indexMetadata.getIndex());
            if (indexService == null) {
                if (IndexName.isPartitioned(indexName)) continue;
                refreshActions.add(CompletableFuture.failedFuture(new IndexNotFoundException(indexName)));
                continue;
            }
            for (IntCursor shardCursor : entry.getValue()) {
                int shardId = shardCursor.value;
                IndexShard shard = indexService.getShard(shardId);
                refreshActions.add(shard.awaitShardSearchActive());
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])refreshActions.toArray(CompletableFuture[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedShardContext prepareContext(ShardId shardId, int readerId) throws IndexNotFoundException {
        SharedShardContext sharedShardContext = this.allocatedShards.get(shardId);
        if (sharedShardContext == null) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            SharedShardContexts sharedShardContexts = this;
            synchronized (sharedShardContexts) {
                sharedShardContext = this.allocatedShards.get(shardId);
                if (sharedShardContext == null) {
                    sharedShardContext = new SharedShardContext(indexService, shardId, readerId, this.wrapSearcher);
                    this.allocatedShards.put(shardId, sharedShardContext);
                }
            }
        }
        assert (sharedShardContext.readerId() == readerId) : "FetchTask cannot create 2 contexts with same shardId and different readerId.\nreaderId is computed deterministically based on shard id";
        return sharedShardContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedShardContext getOrCreateContext(ShardId shardId) throws IndexNotFoundException {
        SharedShardContext sharedShardContext = this.allocatedShards.get(shardId);
        if (sharedShardContext == null) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            SharedShardContexts sharedShardContexts = this;
            synchronized (sharedShardContexts) {
                sharedShardContext = this.allocatedShards.get(shardId);
                if (sharedShardContext == null) {
                    sharedShardContext = new SharedShardContext(indexService, shardId, this.readerId, this.wrapSearcher);
                    this.allocatedShards.put(shardId, sharedShardContext);
                    ++this.readerId;
                }
            }
        }
        return sharedShardContext;
    }

    public String toString() {
        return "SharedShardContexts{allocatedShards=" + String.valueOf(this.allocatedShards.keySet()) + "}";
    }
}

