/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;
import org.jetbrains.annotations.Nullable;

public class KillResponse
extends TransportResponse {
    static final MergeKillResponseFunction MERGE_FUNCTION = new MergeKillResponseFunction();
    private final long numKilled;

    KillResponse(long numKilled) {
        this.numKilled = numKilled;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numKilled);
    }

    public KillResponse(StreamInput in) throws IOException {
        this.numKilled = in.readVLong();
    }

    public long numKilled() {
        return this.numKilled;
    }

    static class MergeKillResponseFunction
    implements Function<List<KillResponse>, KillResponse> {
        MergeKillResponseFunction() {
        }

        @Override
        public KillResponse apply(@Nullable List<KillResponse> input) {
            if (input == null) {
                return new KillResponse(0L);
            }
            long numKilled = 0L;
            for (KillResponse killResponse : input) {
                numKilled += killResponse.numKilled();
            }
            return new KillResponse(numKilled);
        }
    }
}

