/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.kill;

import io.crate.execution.jobs.TasksService;
import io.crate.execution.jobs.kill.KillJobsNodeRequest;
import io.crate.execution.jobs.kill.KillResponse;
import io.crate.execution.jobs.kill.TransportKillNodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportKillJobsNodeAction
extends TransportAction<KillJobsNodeRequest, KillResponse> {
    private final TasksService tasksService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportKillJobsNodeAction(TasksService tasksService, ClusterService clusterService, TransportService transportService) {
        super("internal:crate:sql/kill/jobs");
        this.tasksService = tasksService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerRequestHandler("internal:crate:sql/kill/jobs", "generic", KillJobsNodeRequest.KillJobsRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    public CompletableFuture<KillResponse> nodeOperation(KillJobsNodeRequest.KillJobsRequest request) {
        return this.tasksService.killJobs(request.toKill(), request.userName(), request.reason()).thenApply(KillResponse::new);
    }

    @Override
    public void doExecute(KillJobsNodeRequest request, ActionListener<KillResponse> listener) {
        TransportKillNodeAction.broadcast(this.clusterService, this.transportService, request.innerRequest(), "internal:crate:sql/kill/jobs", listener, request.excludedNodeIds());
    }
}

