/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.BooleanType;
import io.crate.types.DataTypes;

public abstract class Operator<I>
extends Scalar<Boolean, I> {
    public static final BooleanType RETURN_TYPE = DataTypes.BOOLEAN;
    public static final String PREFIX = "op_";

    protected Operator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        for (Symbol symbol : function.arguments()) {
            if (!(symbol instanceof Input) || ((Input)symbol).value() != null) continue;
            return Literal.of(RETURN_TYPE, null);
        }
        return super.normalizeSymbol(function, txnCtx, nodeCtx);
    }
}

