/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class OrOperator
extends Operator<Boolean> {
    public static final String NAME = "op_or";
    public static final Signature SIGNATURE = Signature.builder("op_or", FunctionType.SCALAR).argumentTypes(DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, OrOperator::new);
    }

    public OrOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (function != null) : "function must not be null";
        assert (function.arguments().size() == 2) : "number of args must be 2";
        Symbol left = function.arguments().get(0);
        Symbol right = function.arguments().get(1);
        if (left.symbolType().isValueSymbol() && right.symbolType().isValueSymbol()) {
            return Literal.of((Boolean)this.evaluate(txnCtx, nodeCtx, new Input[]{(Input)left, (Input)right}));
        }
        if (left instanceof Input) {
            Object value = ((Input)left).value();
            if (value == null) {
                return function;
            }
            assert (value instanceof Boolean) : "value must be Boolean";
            if (((Boolean)value).booleanValue()) {
                return Literal.of(true);
            }
            return right;
        }
        if (right instanceof Input) {
            Object value = ((Input)right).value();
            if (value == null) {
                return function;
            }
            assert (value instanceof Boolean) : "value must be Boolean";
            if (((Boolean)value).booleanValue()) {
                return Literal.of(true);
            }
            return left;
        }
        return function;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd argument must not be null";
        Boolean left = (Boolean)args[0].value();
        Boolean right = (Boolean)args[1].value();
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right != false ? Boolean.valueOf(true) : null;
        }
        if (right == null) {
            return left != false ? Boolean.valueOf(true) : null;
        }
        return left != false || right != false;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.setMinimumNumberShouldMatch(1);
        for (Symbol symbol : function.arguments()) {
            query.add(symbol.accept(context.visitor(), context), BooleanClause.Occur.SHOULD);
        }
        return query.build();
    }
}

