/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.all;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.all.AllEqOperator;
import io.crate.expression.operator.all.AllLikeOperator;
import io.crate.expression.operator.all.AllNeqOperator;
import io.crate.expression.operator.all.AllNotLikeOperator;
import io.crate.expression.operator.all.AllRangeOperator;
import io.crate.expression.scalar.ArrayUnnestFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Query;

public abstract sealed class AllOperator<T>
extends Operator<T>
permits AllEqOperator, AllLikeOperator, AllNeqOperator, AllNotLikeOperator, AllRangeOperator {
    public static final String OPERATOR_PREFIX = "_all_";
    public static final List<String> OPERATOR_NAMES = List.of(AllEqOperator.NAME, AllNeqOperator.NAME, AllRangeOperator.Comparison.GT.opName(), AllRangeOperator.Comparison.GTE.opName(), AllRangeOperator.Comparison.LT.opName(), AllRangeOperator.Comparison.LTE.opName(), "_all_like", "_all_ilike", "_all_not_like", "_all_not_ilike");
    protected final DataType<Object> leftType;

    public static void register(Functions.Builder builder) {
        AllOperator.reg(builder, AllEqOperator.NAME, AllEqOperator::new);
        AllOperator.reg(builder, AllNeqOperator.NAME, AllNeqOperator::new);
        AllOperator.regRange(builder, AllRangeOperator.Comparison.GT);
        AllOperator.regRange(builder, AllRangeOperator.Comparison.GTE);
        AllOperator.regRange(builder, AllRangeOperator.Comparison.LT);
        AllOperator.regRange(builder, AllRangeOperator.Comparison.LTE);
    }

    private static void regRange(Functions.Builder builder, AllRangeOperator.Comparison comparison) {
        AllOperator.reg(builder, comparison.opName(), (sig, boundSig) -> new AllRangeOperator((Signature)sig, (BoundSignature)boundSig, comparison));
    }

    private static void reg(Functions.Builder builder, String name, FunctionProvider.FunctionFactory operatorFactory) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("array(E)")).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), operatorFactory);
    }

    public AllOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.leftType = boundSignature.argTypes().get(0);
    }

    abstract boolean matches(T var1, T var2);

    protected abstract Query refMatchesAllArrayLiteral(Function var1, Reference var2, Literal<?> var3, LuceneQueryBuilder.Context var4);

    protected abstract Query literalMatchesAllArrayRef(Function var1, Literal<?> var2, Reference var3, LuceneQueryBuilder.Context var4);

    protected void validateRightArg(T arg) {
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        Object leftValue = args[0].value();
        Collection rightValues = (Collection)args[1].value();
        if (leftValue == null || rightValues == null) {
            return null;
        }
        boolean anyNulls = false;
        int matches = 0;
        for (Object rightValue : rightValues) {
            if (rightValue == null) {
                anyNulls = true;
                ++matches;
                continue;
            }
            this.validateRightArg(rightValue);
            if (!this.matches(leftValue, rightValue)) continue;
            ++matches;
        }
        if (matches == rightValues.size()) {
            return anyNulls ? null : Boolean.valueOf(true);
        }
        return false;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        Function fn;
        List<Symbol> args = function.arguments();
        Symbol probe = args.get(0);
        Symbol candidates = args.get(1);
        while (candidates instanceof Function && (fn = (Function)candidates).signature().equals(ArrayUnnestFunction.SIGNATURE)) {
            candidates = fn.arguments().getFirst();
        }
        if (probe instanceof Literal) {
            Literal literal = (Literal)probe;
            if (candidates instanceof Reference) {
                Reference ref = (Reference)candidates;
                return this.literalMatchesAllArrayRef(function, literal, ref, context);
            }
        }
        if (probe instanceof Reference) {
            Reference ref = (Reference)probe;
            if (candidates instanceof Literal) {
                Literal literal = (Literal)candidates;
                return this.refMatchesAllArrayLiteral(function, ref, literal, context);
            }
        }
        return null;
    }
}

