/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.data.Input;
import io.crate.execution.dml.ArrayIndexer;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.IndexType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import io.crate.types.TypeSignature;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.jetbrains.annotations.Nullable;

public class IsNullPredicate<T>
extends Scalar<Boolean, T> {
    public static final String NAME = "op_isnull";
    public static final Signature SIGNATURE = Signature.builder("op_isnull", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E")).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build();

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, IsNullPredicate::new);
    }

    private IsNullPredicate(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol != null) : "function must not be null";
        assert (symbol.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = symbol.arguments().get(0);
        if (arg instanceof Input) {
            Input input = (Input)arg;
            return Literal.of(input.value() == null);
        }
        return symbol;
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        assert (args.length == 1) : "number of args must be 1";
        return args[0].value() == null;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> arguments = function.arguments();
        assert (arguments.size() == 1) : "`<expression> IS NULL` function must have one argument";
        Symbol symbol = arguments.get(0);
        if (symbol instanceof Reference) {
            Reference ref = (Reference)symbol;
            if (!ref.isNullable()) {
                return new MatchNoDocsQuery("`x IS NULL` on column that is NOT NULL can't match");
            }
            Query refExistsQuery = IsNullPredicate.refExistsQuery(ref, context);
            return refExistsQuery == null ? null : Queries.not(refExistsQuery);
        }
        return null;
    }

    @Nullable
    public static Query refExistsQuery(Reference ref, LuceneQueryBuilder.Context context) {
        boolean canUseFieldsExist;
        String field = ref.storageIdent();
        DataType<?> valueType = ref.valueType();
        boolean bl = canUseFieldsExist = ref.hasDocValues() || ref.indexType() == IndexType.FULLTEXT;
        if (valueType instanceof ArrayType) {
            if (context.tableInfo().versionCreated().onOrAfter(ArrayIndexer.ARRAY_LENGTH_FIELD_SUPPORTED_VERSION)) {
                return ArrayIndexer.arrayLengthExistsQuery(ref, context.tableInfo()::getReference);
            }
            if (canUseFieldsExist) {
                return new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add((Query)new FieldExistsQuery(field), BooleanClause.Occur.SHOULD).add(Queries.not(IsNullPredicate.isNullFuncToQuery(ref, context)), BooleanClause.Occur.SHOULD).build();
            }
            return null;
        }
        StorageSupport<?> storageSupport = valueType.storageSupport();
        if (ref instanceof DynamicReference) {
            if (context.tableInfo().isIgnoredOrImmediateChildOfIgnored(ref)) {
                return null;
            }
            return new MatchNoDocsQuery("DynamicReference/type without storageSupport does not exist");
        }
        if (canUseFieldsExist) {
            return new FieldExistsQuery(field);
        }
        if (context.tableInfo().isIgnoredOrImmediateChildOfIgnored(ref)) {
            return null;
        }
        if (storageSupport != null) {
            if (valueType instanceof ObjectType) {
                ObjectType objType = (ObjectType)valueType;
                if (objType.innerTypes().isEmpty()) {
                    return null;
                }
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1);
                for (Map.Entry<String, DataType<?>> entry : objType.innerTypes().entrySet()) {
                    String childColumn = entry.getKey();
                    Reference childRef = context.getRef(ref.column().getChild(childColumn));
                    if (childRef == null) {
                        return null;
                    }
                    Query refExistsQuery = IsNullPredicate.refExistsQuery(childRef, context);
                    if (refExistsQuery == null) {
                        return null;
                    }
                    booleanQuery.add(refExistsQuery, BooleanClause.Occur.SHOULD);
                }
                return booleanQuery.add(Queries.not(IsNullPredicate.isNullFuncToQuery(ref, context)), BooleanClause.Occur.SHOULD).build();
            }
            if (ref.indexType() == IndexType.NONE) {
                return null;
            }
            return new ConstantScoreQuery((Query)new TermQuery(new Term("_field_names", field)));
        }
        return null;
    }

    static Query isNullFuncToQuery(Symbol arg, LuceneQueryBuilder.Context context) {
        Function isNullFunction = new Function(SIGNATURE, Collections.singletonList(arg), DataTypes.BOOLEAN);
        return LuceneQueryBuilder.genericFunctionFilter(isNullFunction, context);
    }
}

