/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference;

import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.role.Role;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public class StaticTableDefinition<T> {
    private final GetRecords<T> getRecords;
    private final StaticTableReferenceResolver<T> referenceResolver;
    private final boolean involvesIO;

    public StaticTableDefinition(Supplier<CompletableFuture<? extends Iterable<T>>> iterable, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, boolean involvesIO) {
        this.getRecords = (t, u) -> (CompletableFuture)iterable.get();
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = involvesIO;
    }

    public StaticTableDefinition(Supplier<? extends Iterable<T>> iterable, BiPredicate<Role, T> predicate, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories) {
        this.getRecords = (txnCtx, u) -> CompletableFuture.completedFuture(() -> StaticTableDefinition.lambda$new$2((Supplier)iterable, u, predicate));
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = true;
    }

    public StaticTableDefinition(Supplier<CompletableFuture<? extends Iterable<T>>> futureRecords, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, BiPredicate<Role, T> predicate, boolean involvesIO) {
        this.getRecords = (txnCtx, user) -> ((CompletableFuture)futureRecords.get()).thenApply(records -> StreamSupport.stream(records.spliterator(), false).filter(r -> user == null || predicate.test(user, r))::iterator);
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = involvesIO;
    }

    public StaticTableDefinition(GetRecords<T> getRecords, Map<ColumnIdent, ? extends RowCollectExpressionFactory<T>> expressionFactories, boolean involvesIO) {
        this.getRecords = getRecords;
        this.referenceResolver = new StaticTableReferenceResolver(expressionFactories);
        this.involvesIO = involvesIO;
    }

    public CompletableFuture<? extends Iterable<T>> retrieveRecords(TransactionContext txnCtx, @Nullable Role user) {
        return this.getRecords.get(txnCtx, user);
    }

    public StaticTableReferenceResolver<T> getReferenceResolver() {
        return this.referenceResolver;
    }

    public boolean involvesIO() {
        return this.involvesIO;
    }

    private static /* synthetic */ Iterator lambda$new$2(Supplier iterable, Role u, BiPredicate predicate) {
        return StreamSupport.stream(((Iterable)iterable.get()).spliterator(), false).filter(t -> u == null || predicate.test(u, t)).iterator();
    }

    @FunctionalInterface
    public static interface GetRecords<T> {
        public CompletableFuture<? extends Iterable<T>> get(TransactionContext var1, Role var2);
    }
}

