/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.common.collections.Maps;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.types.ArrayType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.Version;
import org.jetbrains.annotations.NotNull;

public class ColumnFieldVisitor
extends StoredFieldVisitor {
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private final Set<ColumnIdent> droppedColumns;
    private final SourceParser storedSourceParser;
    private final Version shardVersion;
    private Map<Field, Object> doc = new TreeMap<Field, Object>();

    public ColumnFieldVisitor(DocTableInfo table, Version shardVersionCreated) {
        this.droppedColumns = table.droppedColumns().stream().map(Reference::column).collect(Collectors.toUnmodifiableSet());
        this.storedSourceParser = new SourceParser((Set<Reference>)table.droppedColumns(), table.lookupNameBySourceKey(), true);
        this.shardVersion = shardVersionCreated;
    }

    public void registerRef(Reference ref) {
        if (this.droppedColumns.contains(ref.column())) {
            return;
        }
        ColumnIdent column = ref.column();
        if (column.name().equals("_doc")) {
            column = column.shiftRight();
        }
        Object storageName = ref.storageIdentLeafName();
        if (ref.valueType() instanceof ArrayType) {
            storageName = "_array_values_" + (String)storageName;
        }
        this.fields.put((String)storageName, new Field(ref.valueType().storageSupportSafe(), column));
    }

    public boolean shouldLoadStoredFields() {
        return !this.fields.isEmpty();
    }

    public void reset() {
        this.doc = new TreeMap<Field, Object>();
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.fields.containsKey(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        Object v = field.decode(this.storedSourceParser, this.shardVersion, value);
        this.doc.put(field, v);
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.doc.put(field, value);
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.doc.put(field, field.decode(value));
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.doc.put(field, field.decode(value));
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.doc.put(field, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        Field field = this.fields.get(fieldInfo.name);
        this.doc.put(field, value);
    }

    public Map<String, Object> getDocMap() {
        HashMap<String, Object> docMap = new HashMap<String, Object>();
        this.doc.forEach((field, v) -> Maps.mergeInto((Map)docMap, (String)field.column().name(), field.column().path(), (Object)v));
        return docMap;
    }

    private record Field(StorageSupport<?> storageSupport, ColumnIdent column) implements Comparable<Field>
    {
        public Object decode(SourceParser sourceParser, Version tableVersion, byte[] v) {
            return this.storageSupport.decode(this.column, sourceParser, tableVersion, v);
        }

        public Object decode(long v) {
            return this.storageSupport.decode(v);
        }

        public Object decode(int v) {
            return this.storageSupport.decode(v);
        }

        @Override
        public int compareTo(@NotNull Field o) {
            return this.column.compareTo(o.column);
        }
    }
}

