/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.common.collections.Maps;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.ColumnFieldVisitor;
import io.crate.expression.reference.doc.lucene.DocCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.PartitionValueInjector;
import io.crate.expression.reference.doc.lucene.RawFieldVisitor;
import io.crate.expression.reference.doc.lucene.SourceFieldVisitor;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.expression.reference.doc.lucene.StoredRow;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public abstract class StoredRowLookup
implements StoredRow {
    public static final Version PARTIAL_STORED_SOURCE_VERSION = Version.V_5_10_0;
    protected final PartitionValueInjector partitionValueInjector;
    protected final DocTableInfo table;
    protected int doc;
    protected ReaderContext readerContext;
    protected boolean docVisited = false;
    protected Map<String, Object> parsedSource = null;

    public static StoredRowLookup create(Version shardCreatedVersion, DocTableInfo table, String indexName) {
        return StoredRowLookup.create(shardCreatedVersion, table, indexName, List.of(), false);
    }

    public static StoredRowLookup create(Version shardCreatedVersion, DocTableInfo table, String indexName, List<Symbol> columns, boolean fromTranslog) {
        if (shardCreatedVersion.before(PARTIAL_STORED_SOURCE_VERSION) || fromTranslog) {
            return new FullStoredRowLookup(table, indexName, columns);
        }
        return new ColumnAndStoredRowLookup(table, shardCreatedVersion, indexName, columns);
    }

    private StoredRowLookup(DocTableInfo table, String indexName) {
        this.partitionValueInjector = PartitionValueInjector.create(indexName, table.partitionedByColumns());
        this.table = table;
    }

    public final StoredRow getStoredRow(ReaderContext context, int doc) {
        boolean reuseReader;
        boolean bl = reuseReader = this.readerContext != null && this.readerContext.reader() == context.reader() && this.doc <= doc;
        if (reuseReader && this.doc == doc) {
            return this;
        }
        this.doc = doc;
        this.readerContext = context;
        try {
            this.moveToDoc(reuseReader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    protected abstract void moveToDoc(boolean var1) throws IOException;

    protected abstract void registerRef(Reference var1);

    public final void register(List<Symbol> symbols) {
        if (symbols != null && !Symbols.hasColumn(symbols, SysColumns.DOC)) {
            Consumer<Reference> register = ref -> {
                if (!ref.column().isSystemColumn() && ref.granularity() == RowGranularity.DOC) {
                    this.registerRef(DocReferences.toDocLookup(ref));
                }
            };
            for (Symbol symbol : symbols) {
                symbol.visit(Reference.class, register);
            }
        } else {
            this.registerAll();
        }
    }

    public void registerAll() {
        for (Reference ref : this.table.columns()) {
            if (!(!ref.column().isSystemColumn() & ref.granularity() == RowGranularity.DOC)) continue;
            this.registerRef(DocReferences.toDocLookup(ref));
        }
    }

    private static class FullStoredRowLookup
    extends StoredRowLookup {
        private final SourceFieldVisitor fieldsVisitor = new SourceFieldVisitor();
        private final SourceParser sourceParser;

        public FullStoredRowLookup(DocTableInfo table, String indexName, List<Symbol> columns) {
            super(table, indexName);
            this.sourceParser = new SourceParser((Set<Reference>)table.droppedColumns(), table.lookupNameBySourceKey(), true);
            this.register(columns);
        }

        @Override
        protected void registerRef(Reference ref) {
            this.sourceParser.register(ref.column(), ref.valueType());
        }

        @Override
        protected void moveToDoc(boolean reuseReader) {
            this.fieldsVisitor.reset();
            this.docVisited = false;
            this.parsedSource = null;
        }

        @Override
        public Map<String, Object> asMap() {
            if (this.parsedSource == null) {
                this.parsedSource = this.partitionValueInjector.injectValues(this.sourceParser.parse(this.loadStoredFields()));
            }
            return this.parsedSource;
        }

        @Override
        public String asRaw() {
            try {
                return CompressorFactory.uncompressIfNeeded(this.loadStoredFields()).utf8ToString();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to decompress source", e);
            }
        }

        private BytesReference loadStoredFields() {
            try {
                if (!this.docVisited) {
                    this.readerContext.visitDocument(this.doc, this.fieldsVisitor);
                    this.docVisited = true;
                }
                return this.fieldsVisitor.source();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ColumnAndStoredRowLookup
    extends StoredRowLookup {
        private final List<ColumnExpression> expressions = new ArrayList<ColumnExpression>();
        private final ColumnFieldVisitor fieldsVisitor;

        private ColumnAndStoredRowLookup(DocTableInfo table, Version shardVersionCreated, String indexName, List<Symbol> columns) {
            super(table, indexName);
            this.fieldsVisitor = new ColumnFieldVisitor(table, shardVersionCreated);
            this.register(columns);
        }

        @Override
        protected void registerRef(Reference ref) {
            this.registerRef(ref, false);
        }

        private void registerRef(Reference ref, boolean fromParents) {
            Object storedParent;
            if (!fromParents && (storedParent = this.table.findParentReferenceMatching(ref, r -> {
                ObjectType objectType;
                DataType<?> patt0$temp = r.valueType();
                return patt0$temp instanceof ObjectType && (objectType = (ObjectType)patt0$temp).columnPolicy() == ColumnPolicy.IGNORED || r.valueType() instanceof ArrayType;
            })) != null) {
                this.fieldsVisitor.registerRef((Reference)storedParent);
            }
            if (ref.hasColumn(SysColumns.DOC) || ref.hasColumn(SysColumns.RAW)) {
                this.registerAll();
            } else if (ref.valueType() instanceof ObjectType) {
                this.fieldsVisitor.registerRef(ref);
                for (Reference leaf : this.table.getChildReferences(ref)) {
                    this.registerRef(leaf, true);
                }
            } else if (ref.valueType().storageSupportSafe().retrieveFromStoredFields() || !ref.hasDocValues()) {
                this.fieldsVisitor.registerRef(ref);
            } else {
                LuceneCollectorExpression<?> expr = LuceneReferenceResolver.typeSpecializedExpression(ref, this.table.isParentReferenceIgnored());
                assert (!(expr instanceof DocCollectorExpression));
                ColumnIdent column = ref.toColumn();
                if (!column.isRoot() && column.name().equals("_doc")) {
                    column = column.shiftRight();
                }
                this.expressions.add(new ColumnExpression(expr, column, ref.storageIdent()));
            }
        }

        @Override
        protected void moveToDoc(boolean reuseReader) throws IOException {
            this.fieldsVisitor.reset();
            this.docVisited = false;
            this.parsedSource = null;
            for (ColumnExpression expr : this.expressions) {
                if (!reuseReader) {
                    expr.expression.setNextReader(this.readerContext);
                }
                expr.expression.setNextDocId(this.doc);
            }
        }

        @Override
        public Map<String, Object> asMap() {
            if (!this.docVisited) {
                try {
                    this.parsedSource = this.buildDocMap();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this.parsedSource;
        }

        @Override
        public String asRaw() {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (XContentBuilder builder = XContentFactory.json((OutputStream)output);){
                RawFieldVisitor visitor = new RawFieldVisitor();
                this.readerContext.visitDocument(this.doc, visitor);
                Map<String, Object> docMap = visitor.getStoredValues();
                for (ColumnExpression expr : this.expressions) {
                    expr.expression.setNextReader(this.readerContext);
                    expr.expression.setNextDocId(this.doc);
                    Object value = expr.expression.value();
                    if (value == null) continue;
                    Maps.mergeInto(docMap, (String)expr.storageName, List.of(), (Object)value);
                }
                builder.map(docMap);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return output.toString(StandardCharsets.UTF_8);
        }

        private Map<String, Object> buildDocMap() throws IOException {
            Map<String, Object> docMap = this.storedMap();
            for (ColumnExpression expr : this.expressions) {
                Object value = expr.expression.value();
                if (value == null) continue;
                Maps.mergeInto(docMap, (String)expr.ident.name(), expr.ident.path(), (Object)value);
            }
            docMap = this.partitionValueInjector.injectValues(docMap);
            this.docVisited = true;
            return docMap;
        }

        private Map<String, Object> storedMap() throws IOException {
            if (this.fieldsVisitor.shouldLoadStoredFields()) {
                this.readerContext.visitDocument(this.doc, this.fieldsVisitor);
                return this.fieldsVisitor.getDocMap();
            }
            return new HashMap<String, Object>();
        }

        private record ColumnExpression(LuceneCollectorExpression<?> expression, ColumnIdent ident, String storageName) {
        }
    }
}

