/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.expression.reference.sys.shard.ShardSegment;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;

@Singleton
public class ShardSegments
implements Iterable<ShardSegment> {
    private final IndicesService indicesService;

    @Inject
    public ShardSegments(IndicesService indicesService) {
        this.indicesService = indicesService;
    }

    @Override
    public Iterator<ShardSegment> iterator() {
        return StreamSupport.stream(this.indicesService.spliterator(), false).flatMap(indexService -> StreamSupport.stream(indexService.spliterator(), false)).filter(x -> !x.routingEntry().unassigned()).flatMap(this::buildShardSegment).iterator();
    }

    private Stream<ShardSegment> buildShardSegment(IndexShard indexShard) {
        try {
            List<Segment> segments = indexShard.segments(false);
            ShardId shardId = indexShard.shardId();
            return segments.stream().map(sgmt -> new ShardSegment(shardId.id(), shardId.getIndexName(), (Segment)sgmt, indexShard.routingEntry().primary()));
        }
        catch (AlreadyClosedException ignored) {
            return Stream.empty();
        }
    }
}

