/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.snapshot;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.shard.ShardId;

public class SysSnapshotRestoreInProgress {
    private final String id;
    private final String name;
    private final String repository;
    private final String state;
    private final List<ShardRestoreInfo> shards;

    public static SysSnapshotRestoreInProgress of(RestoreInProgress.Entry entry) {
        return new SysSnapshotRestoreInProgress(entry.uuid(), entry.snapshot().getSnapshotId().getName(), entry.snapshot().getRepository(), entry.state().name(), ShardRestoreInfo.of(entry.shards()));
    }

    private SysSnapshotRestoreInProgress(String id, String name, String repository, String state, List<ShardRestoreInfo> shards) {
        this.id = id;
        this.name = name;
        this.repository = repository;
        this.state = state;
        this.shards = shards;
    }

    public String id() {
        return this.id;
    }

    public String repository() {
        return this.repository;
    }

    public String name() {
        return this.name;
    }

    public String state() {
        return this.state;
    }

    public List<ShardRestoreInfo> shards() {
        return this.shards;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SysSnapshotRestoreInProgress that = (SysSnapshotRestoreInProgress)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.repository, that.repository) && Objects.equals(this.state, that.state) && Objects.equals(this.shards, that.shards);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.repository, this.state, this.shards);
    }

    public static class ShardRestoreInfo {
        private final int id;
        private final IndexParts indexParts;
        private final RestoreInProgress.State state;

        public static List<ShardRestoreInfo> of(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
            ArrayList<ShardRestoreInfo> shardsRestoreInfo = new ArrayList<ShardRestoreInfo>(shards.size());
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : shards) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                RestoreInProgress.ShardRestoreStatus status = (RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value;
                shardsRestoreInfo.add(new ShardRestoreInfo(shardId.id(), IndexName.decode(shardId.getIndexName()), status.state()));
            }
            return shardsRestoreInfo;
        }

        public ShardRestoreInfo(int id, IndexParts indexParts, RestoreInProgress.State state) {
            this.id = id;
            this.indexParts = indexParts;
            this.state = state;
        }

        public int id() {
            return this.id;
        }

        public IndexParts indexParts() {
            return this.indexParts;
        }

        public RestoreInProgress.State state() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardRestoreInfo that = (ShardRestoreInfo)o;
            return this.id == that.id && Objects.equals(this.indexParts.table(), that.indexParts.table()) && Objects.equals(this.indexParts.schema(), that.indexParts.schema()) && Objects.equals(this.indexParts.partitionIdent(), that.indexParts.partitionIdent()) && this.state == that.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.indexParts, this.state});
        }
    }
}

