/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.EnumSet;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;

public class AgeFunction
extends Scalar<Period, Object> {
    private static final FunctionName NAME = new FunctionName("pg_catalog", "age");

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.TIMESTAMP.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(EnumSet.of(Scalar.Feature.STRICTNULL)).build(), AgeFunction::new);
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.TIMESTAMP.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(EnumSet.of(Scalar.Feature.STRICTNULL)).build(), AgeFunction::new);
    }

    public AgeFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Period evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
        assert (args.length > 0 && args.length < 3) : "Invalid number of arguments";
        Object arg1 = args[0].value();
        if (arg1 == null) {
            return null;
        }
        if (args.length == 1) {
            long curDateMillis = txnCtx.currentInstant().toEpochMilli();
            curDateMillis -= curDateMillis % 86400000L;
            return AgeFunction.getPeriod(curDateMillis, (Long)arg1);
        }
        Object arg2 = args[1].value();
        if (arg2 == null) {
            return null;
        }
        return AgeFunction.getPeriod((Long)arg1, (Long)arg2);
    }

    public static Period getPeriod(long timestamp1, long timestamp2) {
        if (timestamp1 < timestamp2) {
            return new Interval(timestamp1, timestamp2, DateTimeZone.UTC).toPeriod(PeriodType.yearMonthDayTime()).negated();
        }
        return new Interval(timestamp2, timestamp1, DateTimeZone.UTC).toPeriod(PeriodType.yearMonthDayTime());
    }
}

